import random, torch, os
import numpy as np
from torch.backends import cudnn

def setup_seed(seed: int, cuda_deterministic=False):
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    np.random.seed(seed)
    random.seed(seed)
    os.environ["PYTHONHASHSEED"] = str(seed)
    
    # Benchmark mode is good whenever your input sizes for your network do not vary. 
    # This way, cudnn will look for the optimal set of algorithms for 
    # that particular configuration (which takes some time). 
    # This usually leads to faster runtime.
    #
    # But if your input sizes changes at each iteration, 
    # then cudnn will benchmark every time a new size appears, 
    # possibly leading to worse runtime performances.
    cudnn.benchmark = True
    
    if cuda_deterministic:
        # given the same input, and when run on the same software and hardware, 
        # always produce the same output
        cudnn.deterministic = True
    else:
        cudnn.deterministic = False
