import os, sys

class RUN_TYPE:
    COLAB = 'colab' # Train
    HUGGINGFACE = 'huggingface' # Production
    UBUNTU = 'ubuntu' # Train/Test
    KAGGLE = 'kaggle' # Train

def get_run_type() -> str:
    if os.environ.get('KAGGLE_KERNEL_RUN_TYPE'):
        run_type = RUN_TYPE.KAGGLE
    elif 'google.colab' in sys.modules:
        run_type = RUN_TYPE.COLAB
    else:
        run_type = RUN_TYPE.UBUNTU
        # raise Exception('Unrecognized train machine environment')
    return run_type

class RunTypeCls:
    def __init__(self) -> None:
        self.rt: str = get_run_type()

    def set_run_type(self, rt: str) -> None:
        self.rt = rt
        
run_type = RunTypeCls()
