import os
from .run_type import run_type, RUN_TYPE

def install_libraries():
    '''
    @Deprecated
    
    Mount Google Drive if running on Colab
    Install torch==1.12.0 if running on Kaggle
    '''
    if run_type.rt == RUN_TYPE.COLAB:
        if not os.path.isdir('/content/drive'):
            from google.colab import drive
            drive.mount('/content/drive')
    elif run_type.rt == RUN_TYPE.KAGGLE:
        if os.path.isdir('/kaggle/input/rgbdcontinuetraining/sources'):
            os.system('cp -r /kaggle/input/rgbdcontinuetraining/sources /kaggle/working/sources')
        
    elif run_type.rt == RUN_TYPE.UBUNTU:
        # Please use 
        # pip install -r requirements/train.txt
        return
    
    try:
        import timm
    except:
        os.system('pip install -q timm') 

    try: 
        import wandb
    except:
        os.system('pip install -q wandb')

    try:
        import albumentations
    except:
        os.system('pip install -q albumentations')

    try:
        import einops
    except:
        os.system('pip install -q einops')
        
    try:
        import fvcore
    except:
        os.system('pip install -q fvcore')
        
    os.system('pip install -q typed-argument-parser')
    
    try:
        import pthflops
    except:
        os.system('pip install -q pthflops')

    try:
        import pysodmetrics
    except: 
        os.system('pip install -q pysodmetrics==1.3.1')

    if os.environ.get('COLAB_TPU_ADDR') is not None:
        try:
            # imports the torch_xla package
            import torch_xla
        except:
            os.system('pip install -q cloud-tpu-client==0.10 https://storage.googleapis.com/tpu-pytorch/wheels/colab/torch_xla-1.12-cp37-cp37m-linux_x86_64.whl')