

from typing import List


MULTIVIT_PRETRAINED_KEYS = [
    "global_tokens",
    "input_adapters.rgb.pos_emb",
    "input_adapters.rgb.proj.weight",
    "input_adapters.rgb.proj.bias",
    "input_adapters.depth.pos_emb",
    "input_adapters.depth.proj.weight",
    "input_adapters.depth.proj.bias",
    "encoder.0.norm1.weight",
    "encoder.0.norm1.bias",
    "encoder.0.attn.qkv.weight",
    "encoder.0.attn.qkv.bias",
    "encoder.0.attn.proj.weight",
    "encoder.0.attn.proj.bias",
    "encoder.0.norm2.weight",
    "encoder.0.norm2.bias",
    "encoder.0.mlp.fc1.weight",
    "encoder.0.mlp.fc1.bias",
    "encoder.0.mlp.fc2.weight",
    "encoder.0.mlp.fc2.bias",
    "encoder.1.norm1.weight",
    "encoder.1.norm1.bias",
    "encoder.1.attn.qkv.weight",
    "encoder.1.attn.qkv.bias",
    "encoder.1.attn.proj.weight",
    "encoder.1.attn.proj.bias",
    "encoder.1.norm2.weight",
    "encoder.1.norm2.bias",
    "encoder.1.mlp.fc1.weight",
    "encoder.1.mlp.fc1.bias",
    "encoder.1.mlp.fc2.weight",
    "encoder.1.mlp.fc2.bias",
    "encoder.2.norm1.weight",
    "encoder.2.norm1.bias",
    "encoder.2.attn.qkv.weight",
    "encoder.2.attn.qkv.bias",
    "encoder.2.attn.proj.weight",
    "encoder.2.attn.proj.bias",
    "encoder.2.norm2.weight",
    "encoder.2.norm2.bias",
    "encoder.2.mlp.fc1.weight",
    "encoder.2.mlp.fc1.bias",
    "encoder.2.mlp.fc2.weight",
    "encoder.2.mlp.fc2.bias",
    "encoder.3.norm1.weight",
    "encoder.3.norm1.bias",
    "encoder.3.attn.qkv.weight",
    "encoder.3.attn.qkv.bias",
    "encoder.3.attn.proj.weight",
    "encoder.3.attn.proj.bias",
    "encoder.3.norm2.weight",
    "encoder.3.norm2.bias",
    "encoder.3.mlp.fc1.weight",
    "encoder.3.mlp.fc1.bias",
    "encoder.3.mlp.fc2.weight",
    "encoder.3.mlp.fc2.bias",
    "encoder.4.norm1.weight",
    "encoder.4.norm1.bias",
    "encoder.4.attn.qkv.weight",
    "encoder.4.attn.qkv.bias",
    "encoder.4.attn.proj.weight",
    "encoder.4.attn.proj.bias",
    "encoder.4.norm2.weight",
    "encoder.4.norm2.bias",
    "encoder.4.mlp.fc1.weight",
    "encoder.4.mlp.fc1.bias",
    "encoder.4.mlp.fc2.weight",
    "encoder.4.mlp.fc2.bias",
    "encoder.5.norm1.weight",
    "encoder.5.norm1.bias",
    "encoder.5.attn.qkv.weight",
    "encoder.5.attn.qkv.bias",
    "encoder.5.attn.proj.weight",
    "encoder.5.attn.proj.bias",
    "encoder.5.norm2.weight",
    "encoder.5.norm2.bias",
    "encoder.5.mlp.fc1.weight",
    "encoder.5.mlp.fc1.bias",
    "encoder.5.mlp.fc2.weight",
    "encoder.5.mlp.fc2.bias",
    "encoder.6.norm1.weight",
    "encoder.6.norm1.bias",
    "encoder.6.attn.qkv.weight",
    "encoder.6.attn.qkv.bias",
    "encoder.6.attn.proj.weight",
    "encoder.6.attn.proj.bias",
    "encoder.6.norm2.weight",
    "encoder.6.norm2.bias",
    "encoder.6.mlp.fc1.weight",
    "encoder.6.mlp.fc1.bias",
    "encoder.6.mlp.fc2.weight",
    "encoder.6.mlp.fc2.bias",
    "encoder.7.norm1.weight",
    "encoder.7.norm1.bias",
    "encoder.7.attn.qkv.weight",
    "encoder.7.attn.qkv.bias",
    "encoder.7.attn.proj.weight",
    "encoder.7.attn.proj.bias",
    "encoder.7.norm2.weight",
    "encoder.7.norm2.bias",
    "encoder.7.mlp.fc1.weight",
    "encoder.7.mlp.fc1.bias",
    "encoder.7.mlp.fc2.weight",
    "encoder.7.mlp.fc2.bias",
    "encoder.8.norm1.weight",
    "encoder.8.norm1.bias",
    "encoder.8.attn.qkv.weight",
    "encoder.8.attn.qkv.bias",
    "encoder.8.attn.proj.weight",
    "encoder.8.attn.proj.bias",
    "encoder.8.norm2.weight",
    "encoder.8.norm2.bias",
    "encoder.8.mlp.fc1.weight",
    "encoder.8.mlp.fc1.bias",
    "encoder.8.mlp.fc2.weight",
    "encoder.8.mlp.fc2.bias",
    "encoder.9.norm1.weight",
    "encoder.9.norm1.bias",
    "encoder.9.attn.qkv.weight",
    "encoder.9.attn.qkv.bias",
    "encoder.9.attn.proj.weight",
    "encoder.9.attn.proj.bias",
    "encoder.9.norm2.weight",
    "encoder.9.norm2.bias",
    "encoder.9.mlp.fc1.weight",
    "encoder.9.mlp.fc1.bias",
    "encoder.9.mlp.fc2.weight",
    "encoder.9.mlp.fc2.bias",
    "encoder.10.norm1.weight",
    "encoder.10.norm1.bias",
    "encoder.10.attn.qkv.weight",
    "encoder.10.attn.qkv.bias",
    "encoder.10.attn.proj.weight",
    "encoder.10.attn.proj.bias",
    "encoder.10.norm2.weight",
    "encoder.10.norm2.bias",
    "encoder.10.mlp.fc1.weight",
    "encoder.10.mlp.fc1.bias",
    "encoder.10.mlp.fc2.weight",
    "encoder.10.mlp.fc2.bias",
    "encoder.11.norm1.weight",
    "encoder.11.norm1.bias",
    "encoder.11.attn.qkv.weight",
    "encoder.11.attn.qkv.bias",
    "encoder.11.attn.proj.weight",
    "encoder.11.attn.proj.bias",
    "encoder.11.norm2.weight",
    "encoder.11.norm2.bias",
    "encoder.11.mlp.fc1.weight",
    "encoder.11.mlp.fc1.bias",
    "encoder.11.mlp.fc2.weight",
    "encoder.11.mlp.fc2.bias"
]

BASE_MAE_PRETRAINED_KEYS = [
    'global_tokens', 
    'input_adapters.rgb.pos_emb', 
    'input_adapters.rgb.proj.weight', 
    'input_adapters.rgb.proj.bias', 
    'encoder.0.norm1.weight', 
    'encoder.0.norm1.bias', 
    'encoder.0.attn.qkv.weight', 
    'encoder.0.attn.qkv.bias', 
    'encoder.0.attn.proj.weight', 
    'encoder.0.attn.proj.bias', 
    'encoder.0.norm2.weight', 
    'encoder.0.norm2.bias', 
    'encoder.0.mlp.fc1.weight', 
    'encoder.0.mlp.fc1.bias', 
    'encoder.0.mlp.fc2.weight', 
    'encoder.0.mlp.fc2.bias', 
    'encoder.1.norm1.weight', 
    'encoder.1.norm1.bias', 
    'encoder.1.attn.qkv.weight', 
    'encoder.1.attn.qkv.bias', 
    'encoder.1.attn.proj.weight', 
    'encoder.1.attn.proj.bias', 
    'encoder.1.norm2.weight', 
    'encoder.1.norm2.bias', 
    'encoder.1.mlp.fc1.weight', 
    'encoder.1.mlp.fc1.bias', 
    'encoder.1.mlp.fc2.weight', 
    'encoder.1.mlp.fc2.bias', 
    'encoder.2.norm1.weight', 
    'encoder.2.norm1.bias', 
    'encoder.2.attn.qkv.weight', 
    'encoder.2.attn.qkv.bias', 
    'encoder.2.attn.proj.weight', 
    'encoder.2.attn.proj.bias', 
    'encoder.2.norm2.weight', 
    'encoder.2.norm2.bias', 
    'encoder.2.mlp.fc1.weight', 
    'encoder.2.mlp.fc1.bias', 
    'encoder.2.mlp.fc2.weight', 
    'encoder.2.mlp.fc2.bias', 
    'encoder.3.norm1.weight', 
    'encoder.3.norm1.bias', 
    'encoder.3.attn.qkv.weight', 
    'encoder.3.attn.qkv.bias', 
    'encoder.3.attn.proj.weight', 
    'encoder.3.attn.proj.bias', 
    'encoder.3.norm2.weight', 
    'encoder.3.norm2.bias', 
    'encoder.3.mlp.fc1.weight', 
    'encoder.3.mlp.fc1.bias', 
    'encoder.3.mlp.fc2.weight', 
    'encoder.3.mlp.fc2.bias', 
    'encoder.4.norm1.weight', 
    'encoder.4.norm1.bias', 
    'encoder.4.attn.qkv.weight', 
    'encoder.4.attn.qkv.bias', 
    'encoder.4.attn.proj.weight', 
    'encoder.4.attn.proj.bias', 
    'encoder.4.norm2.weight', 
    'encoder.4.norm2.bias', 
    'encoder.4.mlp.fc1.weight', 
    'encoder.4.mlp.fc1.bias', 
    'encoder.4.mlp.fc2.weight', 
    'encoder.4.mlp.fc2.bias', 
    'encoder.5.norm1.weight', 
    'encoder.5.norm1.bias', 
    'encoder.5.attn.qkv.weight', 
    'encoder.5.attn.qkv.bias', 
    'encoder.5.attn.proj.weight', 
    'encoder.5.attn.proj.bias', 
    'encoder.5.norm2.weight', 
    'encoder.5.norm2.bias', 
    'encoder.5.mlp.fc1.weight', 
    'encoder.5.mlp.fc1.bias', 
    'encoder.5.mlp.fc2.weight', 
    'encoder.5.mlp.fc2.bias', 
    'encoder.6.norm1.weight', 
    'encoder.6.norm1.bias', 
    'encoder.6.attn.qkv.weight', 
    'encoder.6.attn.qkv.bias', 
    'encoder.6.attn.proj.weight', 
    'encoder.6.attn.proj.bias', 
    'encoder.6.norm2.weight', 
    'encoder.6.norm2.bias', 
    'encoder.6.mlp.fc1.weight', 
    'encoder.6.mlp.fc1.bias', 
    'encoder.6.mlp.fc2.weight', 
    'encoder.6.mlp.fc2.bias', 
    'encoder.7.norm1.weight', 
    'encoder.7.norm1.bias', 
    'encoder.7.attn.qkv.weight', 
    'encoder.7.attn.qkv.bias', 
    'encoder.7.attn.proj.weight', 
    'encoder.7.attn.proj.bias', 
    'encoder.7.norm2.weight', 
    'encoder.7.norm2.bias', 
    'encoder.7.mlp.fc1.weight', 
    'encoder.7.mlp.fc1.bias', 
    'encoder.7.mlp.fc2.weight', 
    'encoder.7.mlp.fc2.bias', 
    'encoder.8.norm1.weight', 
    'encoder.8.norm1.bias', 
    'encoder.8.attn.qkv.weight', 
    'encoder.8.attn.qkv.bias', 
    'encoder.8.attn.proj.weight', 
    'encoder.8.attn.proj.bias', 
    'encoder.8.norm2.weight', 
    'encoder.8.norm2.bias', 
    'encoder.8.mlp.fc1.weight', 
    'encoder.8.mlp.fc1.bias', 
    'encoder.8.mlp.fc2.weight', 
    'encoder.8.mlp.fc2.bias', 
    'encoder.9.norm1.weight', 
    'encoder.9.norm1.bias', 
    'encoder.9.attn.qkv.weight', 
    'encoder.9.attn.qkv.bias', 
    'encoder.9.attn.proj.weight', 
    'encoder.9.attn.proj.bias', 
    'encoder.9.norm2.weight', 
    'encoder.9.norm2.bias', 
    'encoder.9.mlp.fc1.weight', 
    'encoder.9.mlp.fc1.bias', 
    'encoder.9.mlp.fc2.weight', 
    'encoder.9.mlp.fc2.bias', 
    'encoder.10.norm1.weight', 
    'encoder.10.norm1.bias', 
    'encoder.10.attn.qkv.weight', 
    'encoder.10.attn.qkv.bias', 
    'encoder.10.attn.proj.weight', 
    'encoder.10.attn.proj.bias', 
    'encoder.10.norm2.weight', 
    'encoder.10.norm2.bias', 
    'encoder.10.mlp.fc1.weight', 
    'encoder.10.mlp.fc1.bias', 
    'encoder.10.mlp.fc2.weight', 
    'encoder.10.mlp.fc2.bias', 
    'encoder.11.norm1.weight', 
    'encoder.11.norm1.bias', 
    'encoder.11.attn.qkv.weight', 
    'encoder.11.attn.qkv.bias', 
    'encoder.11.attn.proj.weight', 
    'encoder.11.attn.proj.bias', 
    'encoder.11.norm2.weight', 
    'encoder.11.norm2.bias', 
    'encoder.11.mlp.fc1.weight', 
    'encoder.11.mlp.fc1.bias', 
    'encoder.11.mlp.fc2.weight', 
    'encoder.11.mlp.fc2.bias'
]

LARGE_MAE_PRETRAINED_KEYS = [
    "global_tokens",
    "input_adapters.rgb.proj.weight",
    "input_adapters.rgb.proj.bias",
    "encoder.0.norm1.weight",
    "encoder.0.norm1.bias",
    "encoder.0.attn.qkv.weight",
    "encoder.0.attn.qkv.bias",
    "encoder.0.attn.proj.weight",
    "encoder.0.attn.proj.bias",
    "encoder.0.norm2.weight",
    "encoder.0.norm2.bias",
    "encoder.0.mlp.fc1.weight",
    "encoder.0.mlp.fc1.bias",
    "encoder.0.mlp.fc2.weight",
    "encoder.0.mlp.fc2.bias",
    "encoder.1.norm1.weight",
    "encoder.1.norm1.bias",
    "encoder.1.attn.qkv.weight",
    "encoder.1.attn.qkv.bias",
    "encoder.1.attn.proj.weight",
    "encoder.1.attn.proj.bias",
    "encoder.1.norm2.weight",
    "encoder.1.norm2.bias",
    "encoder.1.mlp.fc1.weight",
    "encoder.1.mlp.fc1.bias",
    "encoder.1.mlp.fc2.weight",
    "encoder.1.mlp.fc2.bias",
    "encoder.2.norm1.weight",
    "encoder.2.norm1.bias",
    "encoder.2.attn.qkv.weight",
    "encoder.2.attn.qkv.bias",
    "encoder.2.attn.proj.weight",
    "encoder.2.attn.proj.bias",
    "encoder.2.norm2.weight",
    "encoder.2.norm2.bias",
    "encoder.2.mlp.fc1.weight",
    "encoder.2.mlp.fc1.bias",
    "encoder.2.mlp.fc2.weight",
    "encoder.2.mlp.fc2.bias",
    "encoder.3.norm1.weight",
    "encoder.3.norm1.bias",
    "encoder.3.attn.qkv.weight",
    "encoder.3.attn.qkv.bias",
    "encoder.3.attn.proj.weight",
    "encoder.3.attn.proj.bias",
    "encoder.3.norm2.weight",
    "encoder.3.norm2.bias",
    "encoder.3.mlp.fc1.weight",
    "encoder.3.mlp.fc1.bias",
    "encoder.3.mlp.fc2.weight",
    "encoder.3.mlp.fc2.bias",
    "encoder.4.norm1.weight",
    "encoder.4.norm1.bias",
    "encoder.4.attn.qkv.weight",
    "encoder.4.attn.qkv.bias",
    "encoder.4.attn.proj.weight",
    "encoder.4.attn.proj.bias",
    "encoder.4.norm2.weight",
    "encoder.4.norm2.bias",
    "encoder.4.mlp.fc1.weight",
    "encoder.4.mlp.fc1.bias",
    "encoder.4.mlp.fc2.weight",
    "encoder.4.mlp.fc2.bias",
    "encoder.5.norm1.weight",
    "encoder.5.norm1.bias",
    "encoder.5.attn.qkv.weight",
    "encoder.5.attn.qkv.bias",
    "encoder.5.attn.proj.weight",
    "encoder.5.attn.proj.bias",
    "encoder.5.norm2.weight",
    "encoder.5.norm2.bias",
    "encoder.5.mlp.fc1.weight",
    "encoder.5.mlp.fc1.bias",
    "encoder.5.mlp.fc2.weight",
    "encoder.5.mlp.fc2.bias",
    "encoder.6.norm1.weight",
    "encoder.6.norm1.bias",
    "encoder.6.attn.qkv.weight",
    "encoder.6.attn.qkv.bias",
    "encoder.6.attn.proj.weight",
    "encoder.6.attn.proj.bias",
    "encoder.6.norm2.weight",
    "encoder.6.norm2.bias",
    "encoder.6.mlp.fc1.weight",
    "encoder.6.mlp.fc1.bias",
    "encoder.6.mlp.fc2.weight",
    "encoder.6.mlp.fc2.bias",
    "encoder.7.norm1.weight",
    "encoder.7.norm1.bias",
    "encoder.7.attn.qkv.weight",
    "encoder.7.attn.qkv.bias",
    "encoder.7.attn.proj.weight",
    "encoder.7.attn.proj.bias",
    "encoder.7.norm2.weight",
    "encoder.7.norm2.bias",
    "encoder.7.mlp.fc1.weight",
    "encoder.7.mlp.fc1.bias",
    "encoder.7.mlp.fc2.weight",
    "encoder.7.mlp.fc2.bias",
    "encoder.8.norm1.weight",
    "encoder.8.norm1.bias",
    "encoder.8.attn.qkv.weight",
    "encoder.8.attn.qkv.bias",
    "encoder.8.attn.proj.weight",
    "encoder.8.attn.proj.bias",
    "encoder.8.norm2.weight",
    "encoder.8.norm2.bias",
    "encoder.8.mlp.fc1.weight",
    "encoder.8.mlp.fc1.bias",
    "encoder.8.mlp.fc2.weight",
    "encoder.8.mlp.fc2.bias",
    "encoder.9.norm1.weight",
    "encoder.9.norm1.bias",
    "encoder.9.attn.qkv.weight",
    "encoder.9.attn.qkv.bias",
    "encoder.9.attn.proj.weight",
    "encoder.9.attn.proj.bias",
    "encoder.9.norm2.weight",
    "encoder.9.norm2.bias",
    "encoder.9.mlp.fc1.weight",
    "encoder.9.mlp.fc1.bias",
    "encoder.9.mlp.fc2.weight",
    "encoder.9.mlp.fc2.bias",
    "encoder.10.norm1.weight",
    "encoder.10.norm1.bias",
    "encoder.10.attn.qkv.weight",
    "encoder.10.attn.qkv.bias",
    "encoder.10.attn.proj.weight",
    "encoder.10.attn.proj.bias",
    "encoder.10.norm2.weight",
    "encoder.10.norm2.bias",
    "encoder.10.mlp.fc1.weight",
    "encoder.10.mlp.fc1.bias",
    "encoder.10.mlp.fc2.weight",
    "encoder.10.mlp.fc2.bias",
    "encoder.11.norm1.weight",
    "encoder.11.norm1.bias",
    "encoder.11.attn.qkv.weight",
    "encoder.11.attn.qkv.bias",
    "encoder.11.attn.proj.weight",
    "encoder.11.attn.proj.bias",
    "encoder.11.norm2.weight",
    "encoder.11.norm2.bias",
    "encoder.11.mlp.fc1.weight",
    "encoder.11.mlp.fc1.bias",
    "encoder.11.mlp.fc2.weight",
    "encoder.11.mlp.fc2.bias",
    "encoder.12.norm1.weight",
    "encoder.12.norm1.bias",
    "encoder.12.attn.qkv.weight",
    "encoder.12.attn.qkv.bias",
    "encoder.12.attn.proj.weight",
    "encoder.12.attn.proj.bias",
    "encoder.12.norm2.weight",
    "encoder.12.norm2.bias",
    "encoder.12.mlp.fc1.weight",
    "encoder.12.mlp.fc1.bias",
    "encoder.12.mlp.fc2.weight",
    "encoder.12.mlp.fc2.bias",
    "encoder.13.norm1.weight",
    "encoder.13.norm1.bias",
    "encoder.13.attn.qkv.weight",
    "encoder.13.attn.qkv.bias",
    "encoder.13.attn.proj.weight",
    "encoder.13.attn.proj.bias",
    "encoder.13.norm2.weight",
    "encoder.13.norm2.bias",
    "encoder.13.mlp.fc1.weight",
    "encoder.13.mlp.fc1.bias",
    "encoder.13.mlp.fc2.weight",
    "encoder.13.mlp.fc2.bias",
    "encoder.14.norm1.weight",
    "encoder.14.norm1.bias",
    "encoder.14.attn.qkv.weight",
    "encoder.14.attn.qkv.bias",
    "encoder.14.attn.proj.weight",
    "encoder.14.attn.proj.bias",
    "encoder.14.norm2.weight",
    "encoder.14.norm2.bias",
    "encoder.14.mlp.fc1.weight",
    "encoder.14.mlp.fc1.bias",
    "encoder.14.mlp.fc2.weight",
    "encoder.14.mlp.fc2.bias",
    "encoder.15.norm1.weight",
    "encoder.15.norm1.bias",
    "encoder.15.attn.qkv.weight",
    "encoder.15.attn.qkv.bias",
    "encoder.15.attn.proj.weight",
    "encoder.15.attn.proj.bias",
    "encoder.15.norm2.weight",
    "encoder.15.norm2.bias",
    "encoder.15.mlp.fc1.weight",
    "encoder.15.mlp.fc1.bias",
    "encoder.15.mlp.fc2.weight",
    "encoder.15.mlp.fc2.bias",
    "encoder.16.norm1.weight",
    "encoder.16.norm1.bias",
    "encoder.16.attn.qkv.weight",
    "encoder.16.attn.qkv.bias",
    "encoder.16.attn.proj.weight",
    "encoder.16.attn.proj.bias",
    "encoder.16.norm2.weight",
    "encoder.16.norm2.bias",
    "encoder.16.mlp.fc1.weight",
    "encoder.16.mlp.fc1.bias",
    "encoder.16.mlp.fc2.weight",
    "encoder.16.mlp.fc2.bias",
    "encoder.17.norm1.weight",
    "encoder.17.norm1.bias",
    "encoder.17.attn.qkv.weight",
    "encoder.17.attn.qkv.bias",
    "encoder.17.attn.proj.weight",
    "encoder.17.attn.proj.bias",
    "encoder.17.norm2.weight",
    "encoder.17.norm2.bias",
    "encoder.17.mlp.fc1.weight",
    "encoder.17.mlp.fc1.bias",
    "encoder.17.mlp.fc2.weight",
    "encoder.17.mlp.fc2.bias",
    "encoder.18.norm1.weight",
    "encoder.18.norm1.bias",
    "encoder.18.attn.qkv.weight",
    "encoder.18.attn.qkv.bias",
    "encoder.18.attn.proj.weight",
    "encoder.18.attn.proj.bias",
    "encoder.18.norm2.weight",
    "encoder.18.norm2.bias",
    "encoder.18.mlp.fc1.weight",
    "encoder.18.mlp.fc1.bias",
    "encoder.18.mlp.fc2.weight",
    "encoder.18.mlp.fc2.bias",
    "encoder.19.norm1.weight",
    "encoder.19.norm1.bias",
    "encoder.19.attn.qkv.weight",
    "encoder.19.attn.qkv.bias",
    "encoder.19.attn.proj.weight",
    "encoder.19.attn.proj.bias",
    "encoder.19.norm2.weight",
    "encoder.19.norm2.bias",
    "encoder.19.mlp.fc1.weight",
    "encoder.19.mlp.fc1.bias",
    "encoder.19.mlp.fc2.weight",
    "encoder.19.mlp.fc2.bias",
    "encoder.20.norm1.weight",
    "encoder.20.norm1.bias",
    "encoder.20.attn.qkv.weight",
    "encoder.20.attn.qkv.bias",
    "encoder.20.attn.proj.weight",
    "encoder.20.attn.proj.bias",
    "encoder.20.norm2.weight",
    "encoder.20.norm2.bias",
    "encoder.20.mlp.fc1.weight",
    "encoder.20.mlp.fc1.bias",
    "encoder.20.mlp.fc2.weight",
    "encoder.20.mlp.fc2.bias",
    "encoder.21.norm1.weight",
    "encoder.21.norm1.bias",
    "encoder.21.attn.qkv.weight",
    "encoder.21.attn.qkv.bias",
    "encoder.21.attn.proj.weight",
    "encoder.21.attn.proj.bias",
    "encoder.21.norm2.weight",
    "encoder.21.norm2.bias",
    "encoder.21.mlp.fc1.weight",
    "encoder.21.mlp.fc1.bias",
    "encoder.21.mlp.fc2.weight",
    "encoder.21.mlp.fc2.bias",
    "encoder.22.norm1.weight",
    "encoder.22.norm1.bias",
    "encoder.22.attn.qkv.weight",
    "encoder.22.attn.qkv.bias",
    "encoder.22.attn.proj.weight",
    "encoder.22.attn.proj.bias",
    "encoder.22.norm2.weight",
    "encoder.22.norm2.bias",
    "encoder.22.mlp.fc1.weight",
    "encoder.22.mlp.fc1.bias",
    "encoder.22.mlp.fc2.weight",
    "encoder.22.mlp.fc2.bias",
    "encoder.23.norm1.weight",
    "encoder.23.norm1.bias",
    "encoder.23.attn.qkv.weight",
    "encoder.23.attn.qkv.bias",
    "encoder.23.attn.proj.weight",
    "encoder.23.attn.proj.bias",
    "encoder.23.norm2.weight",
    "encoder.23.norm2.bias",
    "encoder.23.mlp.fc1.weight",
    "encoder.23.mlp.fc1.bias",
    "encoder.23.mlp.fc2.weight",
    "encoder.23.mlp.fc2.bias"
]

HUGE_MAE_PRETRAINED_KEYS = []

def get_keys_by_pretrained_backbone_name(pretrained_backbone_name: str) -> List[str]:
    if pretrained_backbone_name == 'multi-vit':
        return MULTIVIT_PRETRAINED_KEYS

    if pretrained_backbone_name == 'mae':
        return BASE_MAE_PRETRAINED_KEYS
    
    if pretrained_backbone_name == 'large-mae':
        return LARGE_MAE_PRETRAINED_KEYS
    
    if pretrained_backbone_name == 'huge-mae':
        return HUGE_MAE_PRETRAINED_KEYS
    
    raise Exception(f'Unsupported pretrained backbone name {pretrained_backbone_name}')
