
class GradientAccumulation:
    
    def __init__(
        self, accum_iter: int, niters_per_epoch: int
    ):
        self.accum_iter = accum_iter
        self.niters_per_epoch = niters_per_epoch
        
    def is_zero_gradients(self, batch_idx: int) -> bool:
        return batch_idx % self.accum_iter == 0 or \
            batch_idx == self.niters_per_epoch
            
    def is_back_prop(self, batch_idx: int) -> bool:
        return batch_idx % self.accum_iter == 0 or \
            batch_idx == self.niters_per_epoch
    
            