from fvcore.nn import FlopCountAnalysis
import torch
from pthflops import count_ops

from .device import device
from .model.multimae import MultiViT

def calculate_gflops(model: MultiViT, image_size: int) -> float:
    """Note: the model is set to Eval Mode after calling this function
    
    1 GFLOP = 1e9 FLOP(s)
    """
    model.eval()
    
    rgbs = torch.randn((1, 3, image_size, image_size)).to(device)
    depths = torch.randn((1, 1, image_size, image_size)).to(device)
    inputs = {
        'rgb': rgbs,
        'depth': depths
    }
    
    # flops = FlopCountAnalysis(model, inputs)
    # print('GFLOPS:', flops.total() / 1000000000)
    # return flops.total() / 1e9
    
    flops = model.calculate_flops(inputs)
    print('flops', flops)
