import numpy as np
from py_sod_metrics import MAE, Emeasure, Fmeasure, Smeasure

def ndarray_to_basetype(data):
    def _to_list_or_scalar(item):
        listed_item = item.tolist()
        if isinstance(listed_item, list) and len(listed_item) == 1:
            listed_item = listed_item[0]
        return listed_item

    if isinstance(data, (tuple, list)):
        results = [_to_list_or_scalar(item) for item in data]
    elif isinstance(data, dict):
        results = {k: _to_list_or_scalar(item) for k, item in data.items()}
    else:
        assert isinstance(data, np.ndarray)
        results = _to_list_or_scalar(data)
    return results


class CalTotalMetric(object):
    def __init__(self):
        self.mae = MAE()
        self.fm = Fmeasure()
        self.sm = Smeasure()
        self.em = Emeasure()
        # self.wfm = WeightedFmeasure()

    def step(self, pre: np.ndarray, gt: np.ndarray):
        assert pre.shape == gt.shape
        assert pre.dtype == np.uint8
        assert gt.dtype == np.uint8

        self.mae.step(pre, gt)
        self.sm.step(pre, gt)
        self.fm.step(pre, gt)
        self.em.step(pre, gt)
        # self.wfm.step(pre, gt)

    def get_results(self, num_bits: int = 8, return_ndarray: bool = False) -> dict:
        fm_info = self.fm.get_results()
        fm = fm_info["fm"]
        # pr = fm_info["pr"]
        # wfm = self.wfm.get_results()["wfm"]
        sm = self.sm.get_results()["sm"]
        em = self.em.get_results()["em"]
        mae = self.mae.get_results()["mae"]

        numerical_results = {
            "SM": sm,
            "MAE": mae,
            "maxE": em["curve"].max(),
            # "avgE": em["curve"].mean(),
            # "adpE": em["adp"],
            "maxF": fm["curve"].max(),
            # "avgF": fm["curve"].mean(),
            # "adpF": fm["adp"],
            # "wFm": wfm,
        }
        if num_bits is not None and isinstance(num_bits, int):
            numerical_results = {k: v.round(num_bits) for k, v in numerical_results.items()}
        if not return_ndarray:
            numerical_results = ndarray_to_basetype(numerical_results)
        return numerical_results