from tqdm import tqdm
import torch
import numpy as np
import wandb
import pandas as pd

from .dataset_fn import TestDataset
from .configs.base_config import base_cfg

def calculate_distribution_of_dataset(dataset: TestDataset) -> np.ndarray:
    '''Return distribution salient object of a dataset'''
    _, _, sum_gt, _, _, _ = dataset[0]

    for index in tqdm(range(1, len(dataset))):
        _, _, gt, _, _, _ = dataset[index]
        sum_gt += gt

    sum_gt = torch.permute(sum_gt, (1,2,0)).squeeze().numpy()
    sum_gt /= np.max(sum_gt)
    return sum_gt

def log_distribution_of_dataset(cfg: base_cfg) -> None:
    raise NotImplementedError()
    train_distribution = calculate_distribution_of_dataset(
        TestDataset(
            cfg.train_dataset_working_dir_path, cfg.image_size,
            version=2, is_padding=True,
            inputs=cfg.inputs, outputs=cfg.outputs,
        )
    )

    normal_test_distribution = calculate_distribution_of_dataset(
        TestDataset(
            cfg.normal_test_dataset_working_dir_path, cfg.image_size,
            version=2, is_padding=True,
            inputs=cfg.inputs, outputs=cfg.outputs,
        )
    )

    difficult_test_distribution = calculate_distribution_of_dataset(
        TestDataset(
            cfg.difficult_test_dataset_working_dir_path, cfg.image_size,
            version=2, is_padding=True,
            inputs=cfg.inputs, outputs=cfg.outputs,
        )
    )
    table = [
        ['train', wandb.Image(train_distribution)],
        ['normal_test', wandb.Image(normal_test_distribution)],
        ['difficult_test', wandb.Image(difficult_test_distribution)]
    ]
    columns = ['Dataset', 'Distribution']

    df = pd.DataFrame(data=table, columns=columns)
    wandb.login(key=cfg.wandb_api_key)
    run = wandb.init(name='Datasets', project='RGBD_SOD', 
                        id='Datasets', resume='auto')
    run.log({
        'distribution': wandb.Table(dataframe=df, columns=columns),
    })
    run.finish()
