import os, torch

def get_device():
    if os.environ.get('COLAB_TPU_ADDR') is not None:
        # Make sure you already installed torch_xla
        # !pip install -q cloud-tpu-client==0.10 https://storage.googleapis.com/tpu-pytorch/wheels/colab/torch_xla-1.12-cp37-cp37m-linux_x86_64.whl
        import torch_xla
        import torch_xla.core.xla_model as xm
        return xm.xla_device()
    elif torch.cuda.is_available():
        return torch.device('cuda')
    else:
        return torch.device('cpu')

device = get_device()
cpu_device = torch.device('cpu')