import os, torch

from .rgbd_model import RGBDModel
from .configs.base_config import base_cfg
from .run_type import run_type
from .checkpoint import load_checkpoint

def build_model(cfg: base_cfg) -> None:
    model = RGBDModel(cfg, run_type=run_type.rt)
    checkpoint_file_name = f'checkpoint_{cfg.em.best_epoch}.pt'
    load_checkpoint(
        model, None, None, None, 
        os.path.join(cfg.experiment_dir_path, cfg.experiment_name, checkpoint_file_name), 
        None
    )
    deployment_experiment_dir_path = os.path.join(
        cfg.deployment_dir_path, cfg.experiment_name 
    )
    os.makedirs(deployment_experiment_dir_path, exist_ok=True)
    deployment_checkpoint_file_path = os.path.join(deployment_experiment_dir_path, checkpoint_file_name)
    torch.save(model.state_dict(), deployment_checkpoint_file_path)
    print('deployment_checkpoint_file_path', deployment_checkpoint_file_path)

