import os
from typing import List
import wget

from .configs.base_config import base_cfg

def backup(cfg: base_cfg, urls: List[str]):
    current_experiment_dir_path = os.path.join(
        cfg.experiment_dir_path,
        cfg.experiment_name
    )
    
    os.makedirs(current_experiment_dir_path, exist_ok=True)
    
    for url in urls:
        wget.download(url, out = current_experiment_dir_path)
