import torch
from torch import Tensor, nn

from lib import network_auxi as network
from lib.net_tools import get_func

class RelDepthModel(nn.Module):
    def __init__(self, backbone: str = 'resnet50'):
        super(RelDepthModel, self).__init__()
        if backbone == 'resnet50':
            encoder = 'resnet50_stride32'
        elif backbone == 'resnext101':
            encoder = 'resnext101_stride32x8d'
        self.depth_model = DepthModel(encoder)

    def inference(self, rgb: Tensor) -> Tensor:
        with torch.no_grad():
            depth: Tensor = self.depth_model(rgb)
            pred_depth_out = depth - depth.min() + 0.01
            return pred_depth_out


class DepthModel(nn.Module):
    def __init__(self, encoder: str):
        super(DepthModel, self).__init__()
        backbone = network.__name__.split('.')[-1] + '.' + encoder
        self.encoder_modules = get_func(backbone)()
        self.decoder_modules = network.Decoder()

    def forward(self, x: Tensor) -> Tensor:
        lateral_out = self.encoder_modules(x)
        out_logit = self.decoder_modules(lateral_out)
        return out_logit