import time

import numpy as np
import streamlit as st
from PIL import Image

from base_model import BaseRGBDModel
from depth_model import BaseDepthModel
from model import base_inference


def image_inference(
    depth_model: BaseDepthModel, 
    sod_model: BaseRGBDModel, 
    color: np.ndarray
) -> None:
    col1, col2, col3 = st.columns(3)

    with col1:
        img_file_buffer = st.file_uploader(
            'Upload an RGB image', key='img_file_buffer', 
            type=['png', 'jpg', 'jpeg']
        )
        image: Image = None
        depth: Image = None
        if img_file_buffer is not None:
            image = Image.open(img_file_buffer).convert('RGB')
            # image = np.array(image)
            st.image(image, caption='RGB image input')

    with col2:
        depth_file_buffer = st.file_uploader(
            'Upload a depth image (Optional)', 
            key='depth_file_buffer', type=['png', 'jpg', 'jpeg']
        )
        if depth_file_buffer is not None:
            depth = Image.open(depth_file_buffer).convert('L')
            # depth = np.array(depth)
            st.image(depth, caption='Depth image input')

    with col3:
        is_predict = st.button(
            'Predict Salient Objects', 
            key='predict_salient_objects', 
            disabled=img_file_buffer is None,
        )
        if is_predict:
            with st.spinner('Processing...'):
                start_time = time.time()
                pred_depth, pred_sod, pred_sm = base_inference(
                    depth_model, sod_model, image, depth, color
                )
                if depth is None:
                    col2.image(pred_depth, 'Depth')
                st.info(f"Inference time: {time.time() - start_time:.4f} seconds")
                st.image(pred_sod, 'Salient Objects')
                st.image(pred_sm, 'Salient Map')
