import os

import streamlit as st

from app_utils import load_video

cwd = os.getcwd()

def video_demo():
    videos_root_dir = os.path.join('demo', 'video')
    video_names = [f for f in os.listdir(videos_root_dir) if os.path.isdir(os.path.join(videos_root_dir, f))]

    video_name_1 = st.selectbox(
        'Choose video 1',
        video_names,
        key='video_name_1',
    )

    load_video(os.path.join(videos_root_dir, video_name_1, 'result.mp4'))

    video_name_2 = st.selectbox(
        'Choose video 2',
        video_names,
        key='video_name_2',
    )

    load_video(os.path.join(videos_root_dir, video_name_2, 'result.mp4'))

def demo() -> None:
    video_demo()