import os

import numpy as np
import torch
import torch.nn.functional as F
import torchvision.transforms as transforms
from PIL import Image
from torch import Tensor

from app_utils import normalize
from base_model import BaseRGBDModel
from BBSNet.BBSNet_model import BBSNet
from device import cpu_device, device


class BBSNetModel(BaseRGBDModel):
    def __init__(self):
        """Wrapper of BBSNet"""
        super(BBSNetModel, self).__init__()
        print('BBSNetconstructor')
        self.model = BBSNet()

        self.model.load_state_dict(
            torch.load(
                os.path.join('pretrained_models', 'BBSNet', 'BBSNet.pth'),
                map_location=cpu_device
            )
        )
        self.model.to(device)
        self.model.eval()

        self.testsize = 352
        self.images_transform = transforms.Compose([
            transforms.Resize((self.testsize, self.testsize)),
            transforms.Normalize(
                [0.485, 0.456, 0.406], [0.229, 0.224, 0.225])
            ])
        self.depths_transform = transforms.Compose([
            transforms.Resize((self.testsize, self.testsize)),
        ])
        
    def inference(
        self, image: Tensor, depth: Tensor,
    ) -> np.ndarray:
        origin_shape = image.shape

        # 1. Preprocessing
        image: Tensor = self.images_transform(image)
        depth: Tensor = self.depths_transform(depth)
        images = image.unsqueeze(0)
        depths = depth.unsqueeze(0)

        # 2. Inference
        images, depths = images.to(device), depths.to(device)
        pred_no_sigmoid = self.model(images, depths)[1]
        
        # 3. Return saliency maps
        res: Tensor = F.interpolate(
            pred_no_sigmoid, size=(origin_shape[1], origin_shape[2]), 
            mode='bilinear', align_corners=False
        )
        res = res.sigmoid().data.cpu().numpy().squeeze()
        res = normalize(res)

        return res