import multiprocessing

import streamlit as st

from color_selection_ui import color_selection_ui
from depth_selection_ui import depth_selection_ui
from device import device
from s_multimae.run_type import RUN_TYPE, run_type
from sod_selection_ui import sod_selection_ui

run_type.set_run_type(RUN_TYPE.HUGGINGFACE)

class MODE:
    IMAGE = 'image'
    VIDEO = 'video'
    WEBRTC = 'webrtc'
    DEMO = 'demo'

st.set_page_config(
    page_title='RGB-D Salient Object Detection Multi-modal Masked Autoencoders (dubbed S-MultiMAE)',
    page_icon="🧊",
    layout="wide",
    initial_sidebar_state="expanded",
    menu_items={
        'Get Help': 'https://www.extremelycoolapp.com/help',
        'Report a bug': "https://www.extremelycoolapp.com/bug",
        'About': "# This is a header. This is an *extremely* cool app!"
    }
)

st.title('RGB-D Salient Object Detection Multi-modal Masked Autoencoders (S-MultiMAE)')

with st.expander("INTRODUCTION"):
    st.text(f'''Streamlit demo for S-MultiMAE. 
        Author: Huynh Nguyen Truong Thinh
        Device: {device.type}
        Number of CPU(s): {multiprocessing.cpu_count()}
    ''')

with st.expander("OPTIONS"):
    col1, col2 = st.columns(2)

    with col1:
        mode = st.radio(
            "Mode", 
            (
                MODE.IMAGE, MODE.VIDEO, 
                MODE.WEBRTC, MODE.DEMO,
            )
        )
        st.markdown("---")
        color = color_selection_ui()

    with col2:
        depth_model = depth_selection_ui()
        st.markdown("---")
        sod_model = sod_selection_ui()

if mode == MODE.IMAGE:
    from image_inference import image_inference
    image_inference(depth_model, sod_model, color)
elif mode == MODE.VIDEO:
    from video_inference import video_inference
    video_inference(depth_model, sod_model, color)
elif mode == MODE.WEBRTC:
    from webrtc_app import webrtc_app
    webrtc_app(depth_model, sod_model, color)
elif mode == MODE.DEMO:
    from demo import demo
    demo()

