import gradio as gr
from youtube_timestamper.core import YoutubeTimestamper
import datetime

def timestamp(url, q_thresh):
    print(url)
    yt_timestamper = YoutubeTimestamper(url)
    yt_timestamper.suggest_question_timestamps(q_thresh)
    output=""
    for t in yt_timestamper.timestamps:
        timestamp = f"{datetime.timedelta(seconds=t[0])}"
        timestamp = timestamp.split(".")[0].rjust(8, "0")
        stamp = f"{timestamp} {t[1]}"
        output += "\n" + stamp
    output += "\n\nCreated using youtube-timestamper - https://ilangurudev.github.io/youtube-timestamper/"
    return output.strip()

title  = "Youtube Timestamper"
description = "Create timestamps for youtube interview videos using NLP."
article = "For more details visit https://ilangurudev.github.io/youtube-timestamper/ "

iface = gr.Interface(fn=timestamp, 
                     inputs=[gr.inputs.Textbox(label="YouTube video url"), gr.inputs.Slider(0, 50, 1, 15, label="Maximum number of words between consecutive questions")], 
                     outputs=gr.inputs.Textbox(label="Timestamps", lines=20), 
                     title=title,
                     description=description,
                     article=article,
                     examples=[["https://www.youtube.com/watch?v=QGCvycOXs2M", 20], ["https://www.youtube.com/watch?v=RvwynqDUoQE", 20]],)
iface.launch()