# https://huggingface.co/tuner007/pegasus_paraphrase

import torch
from transformers import PegasusForConditionalGeneration, PegasusTokenizer

model_name = 'tuner007/pegasus_paraphrase'
torch_device = 'cuda' if torch.cuda.is_available() else 'cpu'
tokenizer = PegasusTokenizer.from_pretrained(model_name)
model = PegasusForConditionalGeneration.from_pretrained(model_name).to(torch_device)

def get_response(input_text,num_return_sequences):
  batch = tokenizer.prepare_seq2seq_batch([input_text],truncation=True,padding='longest',max_length=60, return_tensors="pt").to(torch_device)
  translated = model.generate(**batch,max_length=60,num_beams=10, num_return_sequences=num_return_sequences, temperature=1.5)
  tgt_text = tokenizer.batch_decode(translated, skip_special_tokens=True)
  return tgt_text




from sentence_splitter import SentenceSplitter, split_text_into_sentences

splitter = SentenceSplitter(language='en')

def paraphraze(text):
  sentence_list = splitter.split(text)
  paraphrase = []

  for i in sentence_list:
    a = get_response(i,1)
    paraphrase.append(a)
    paraphrase2 = [' '.join(x) for x in paraphrase]
    paraphrase3 = [' '.join(x for x in paraphrase2) ]
  paraphrased_text = str(paraphrase3).strip('[]').strip("'")
  return paraphrased_text


#python3
#build a text summarizer using hugging face and gradio 
#https://pypi.org/project/gradio/
#https://huggingface.co/transformers/
import gradio as gr
import transformers
from transformers import pipeline
import yake



summarizer = pipeline("summarization")

kw_extractor = yake.KeywordExtractor()
language = "en"
max_ngram_size = 3
deduplication_threshold = 0.9
numOfKeywords = 20
custom_kw_extractor = yake.KeywordExtractor(lan=language, n=max_ngram_size, dedupLim=deduplication_threshold, top=numOfKeywords, features=None)

def summarize(text):
  keywords_2 = []
  summ = summarizer(text, max_length=200, min_length=30)[0]['summary_text']
  keywords = custom_kw_extractor.extract_keywords(text)
  for i in range(len(keywords)):
    keywords_2.append(keywords[i][0])

  paraphrased_text = paraphraze(text)
  return [summ,keywords_2,paraphrased_text]
gr.Interface(fn=summarize, inputs=gr.inputs.Textbox(lines=7, placeholder="Enter text here"), outputs=[gr.outputs.Textbox(label="Summary"),gr.outputs.Textbox(label="keywords"),gr.outputs.Textbox(label="Paraphrased Text")],examples=[["Simultaneous localization and mapping (SLAM) is the computational problem of constructing or updating a map of an unknown environment while simultaneously keeping track of an agent's location within it. While this initially appears to be a chicken-and-egg problem there are several algorithms known for solving it, at least approximately, in tractable time for certain environments. Popular approximate solution methods include the particle filter, extended Kalman filter, covariance intersection, and GraphSLAM. SLAM algorithms are based on concepts in computational geometry and computer vision, and are used in robot navigation, robotic mapping and odometry for virtual reality or augmented reality.SLAM algorithms are tailored to the available resources, hence not aimed at perfection, but at operational compliance. Published approaches are employed in self-driving cars, unmanned aerial vehicles, autonomous underwater vehicles, planetary rovers, newer domestic robots and even inside the human body. In December 2021, Disney received a patent on augmented reality technology based on SLAM techniques with an array of external projectors, so that AR-enabled headsets or smartphones are not required."],
["Cleopatra VII Philopator  was queen of the Ptolemaic Kingdom of Egypt from 51 to 30 BC, and its last active ruler.A member of the Ptolemaic dynasty, she was a descendant of its founder Ptolemy I Soter, a Macedonian Greek general and companion of Alexander the Great.After the death of Cleopatra, Egypt became a province of the Roman Empire, marking the end of the second to last Hellenistic state and the age that had lasted since the reign of Alexander (336–323 BC).Her native language was Koine Greek, and she was the only Ptolemaic ruler to learn the Egyptian language.In 58 BC, Cleopatra presumably accompanied her father, Ptolemy XII Auletes, during his exile to Rome after a revolt in Egypt (a Roman client state) allowed his rival daughter Berenice IV to claim his throne. Berenice was killed in 55 BC when Ptolemy returned to Egypt with Roman military assistance. When he died in 51 BC, the joint reign of Cleopatra and her brother Ptolemy XIII began, but a falling-out between them led to open civil war. After losing the 48 BC Battle of Pharsalus in Greece against his rival Julius Caesar (a Roman dictator and consul) in Caesar's Civil War, the Roman statesman Pompey fled to Egypt. Pompey had been a political ally of Ptolemy XII, but Ptolemy XIII, at the urging of his court eunuchs, had Pompey ambushed and killed before Caesar arrived and occupied Alexandria. Caesar then attempted to reconcile the rival Ptolemaic siblings, but Ptolemy's chief adviser, Potheinos, viewed Caesar's terms as favoring Cleopatra, so his forces besieged her and Caesar at the palace. Shortly after the siege was lifted by reinforcements, Ptolemy XIII died in the 47 BC Battle of the Nile; Cleopatra's half-sister Arsinoe IV was eventually exiled to Ephesus for her role in carrying out the siege. Caesar declared Cleopatra and her brother Ptolemy XIV joint rulers but maintained a private affair with Cleopatra that produced a son, Caesarion. Cleopatra traveled to Rome as a client queen in 46 and 44 BC, where she stayed at Caesar's villa. After the assassinations of Caesar and (on her orders) Ptolemy XIV in 44 BC, she named Caesarion co-ruler as Ptolemy XV."],
["A black hole is a region of spacetime where gravity is so strong that nothing — no particles or even electromagnetic radiation such as light — can escape from it. The theory of general relativity predicts that a sufficiently compact mass can deform spacetime to form a black hole.The boundary of no escape is called the event horizon. Although it has an enormous effect on the fate and circumstances of an object crossing it, it has no locally detectable features according to general relativity.In many ways, a black hole acts like an ideal black body, as it reflects no light. Moreover, quantum field theory in curved spacetime predicts that event horizons emit Hawking radiation, with the same spectrum as a black body of a temperature inversely proportional to its mass. This temperature is of the order of billionths of a kelvin for stellar black holes, making it essentially impossible to observe directly.Objects whose gravitational fields are too strong for light to escape were first considered in the 18th century by John Michell and Pierre-Simon Laplace.In 1916, Karl Schwarzschild found the first modern solution of general relativity that would characterize a black hole. David Finkelstein, in 1958, first published the interpretation of black hole as a region of space from which nothing can escape. Black holes were long considered a mathematical curiosity; it was not until the 1960s that theoretical work showed they were a generic prediction of general relativity. The discovery of neutron stars by Jocelyn Bell Burnell in 1967 sparked interest in gravitationally collapsed compact objects as a possible astrophysical reality. The first black hole known was Cygnus X-1, identified by several researchers independently in 1971."
]]).launch(inline=False)