# encoding:utf-8

import config
import gradio as gr
from channel import channel_factory
from common.log import logger
from io import BytesIO
from PIL import Image
from concurrent.futures import ThreadPoolExecutor
thread_pool = ThreadPoolExecutor(max_workers=8)

def getImage(bytes):
    bytes_stream = BytesIO(bytes)
    image = Image.open(bytes_stream)
    return image

def getLoginUrl():
    # load config
        config.load_config()
        
        # create channel
        bot = channel_factory.create_channel("wx")
        thread_pool.submit(bot.startup)

        while (True):
            if bot.getQrCode():
                return getImage(bot.getQrCode())

if __name__ == '__main__':
    try:
        
        with gr.Blocks() as demo:
            with gr.Row():
                with gr.Column():
                    btn = gr.Button(value="生成二维码")
                with gr.Column():
                    outputs=[gr.Pil()]
                btn.click(getLoginUrl, outputs=outputs)

        demo.launch()


    except Exception as e:
        logger.error("App startup failed!")
        logger.exception(e)
