import os
import openai

from langchain.chains import ConversationalRetrievalChain, RetrievalQA
from langchain.chat_models import ChatOpenAI
from langchain.document_loaders import TextLoader
from langchain.embeddings import OpenAIEmbeddings
from langchain.indexes import VectorstoreIndexCreator
from langchain.indexes.vectorstore import VectorStoreIndexWrapper
from langchain.llms import OpenAI
from langchain.vectorstores import Chroma
from langchain.memory import ConversationBufferMemory

import chromadb
import chromadb.config

import tiktoken
import gradio as gr

os.environ["OPENAI_API_KEY"] = "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"
PERSIST = False

def main_func(message , history):
  chat_history = []
  if PERSIST and os.path.exists("persist"):
    print("Reusing index...\n")
    vectorstore = Chroma(persist_directory="persist", embedding_function=OpenAIEmbeddings())
    index = VectorStoreIndexWrapper(vectorstore=vectorstore)
  else:
    loader = TextLoader("data.txt")
    if PERSIST:
      index = VectorstoreIndexCreator(vectorstore_kwargs={"persist_directory":"persist"}).from_loaders([loader])
    else:
      index = VectorstoreIndexCreator().from_loaders([loader])
  print(index)

  memory = ConversationBufferMemory(memory_key="chat_history", return_messages=True)
  chain = ConversationalRetrievalChain.from_llm(llm=ChatOpenAI(), retriever=index.vectorstore.as_retriever(), memory=memory, verbose=True)

  query = message
  result = chain({"question": query, "chat_history": chat_history})
  print(result['answer'])
  chat_history.append((query, result['answer']))
  return result['answer']

gr.ChatInterface(main_func ,title="CHIT CHAT 🤖",
                 chatbot=gr.Chatbot(height=550),
                 textbox=gr.Textbox(placeholder="Ask me anything about the artifacts" )).launch()