---
title: README
emoji: 🎨
colorFrom: indigo
colorTo: pink
sdk: static
pinned: false
---
# Welcome to the Gradio Themes Party 🎉
## Join the organization by clicking the 'Request to join this org' button on the top-right corner
### <a href="https://huggingface.co/spaces/gradio/theme-gallery" style="text-decoration: underline" target="_blank">Live Themes Gallery</a> will show Gradio Themes that are created by participants and they will be sorted by likes.
<img class="lg:col-span-2" src="https://huggingface.co/spaces/Gradio-Themes/README/resolve/main/theme_header.png" alt="Gradio Theme Party Banner" style="margin:10px"><br>


- We would like to invite you to the **Gradio Themes Party**, a community event aimed at designing visually stunning and personalized themes for Gradio apps. The event will take place over roughly a three-week period, **starting from Tuesday, March 21st** and **ending on Sunday, April 9th**. 
- We will be organizing this event here on <a href="https://huggingface.co/Gradio-Themes" target="_blank" style="text-decoration: underline">Huggingface Hub</a> and will be communicating with participants through the <a href="https://discord.gg/YtB7bm2H" target="_blank" style="text-decoration: underline">HuggingFace Discord Server</a>. Check the dedicated Gradio channel to stay updated with the event. Prizes will be given at the end of the event. See the Prizes section below. 
- If there is something you would like to style via the theming API but it isn't currently supported, please use this <a href="https://github.com/gradio-app/gradio/issues/3544" target="_blank">Github Issue</a> to report it. You can add a reply to this issue detailing what you would like to style and how you would like to style it and we will get back to you on it. 

## Hackathon Tracks :
Participants can take part in different tracks of the Themes Hackathon. Each track will have winners announced at the end of the event! These tracks are:
1. **General Theme Creation** - Participants need to create the most creative or visually stunning theme for a Gradio app. We will add the best/most creative theme to our set of default themes as a prize, plus the top three winners will get prizes.
2. **Sector-specific Themes** - Participants create Gradio themes targeting specific sectors like finance/health/education/art, or specific companies -- for example, a Hugging Face emoji theme or a meta blue theme, etc.
3. **Inclusivity and Accessibility** focused themes - Participants can submit apps built around themes that prioritize inclusivity and accessibility. This segment places a strong emphasis on accessibility, for example, building an app with themes that are tailored to those who are colorblind or creating apps that support causes related to diversity and inclusion.
4. **Gradio in Disguise🥸** themes - In this track, we encourage participants to design themes that give Gradio a completely different look and feel from its default theme. This involves creating unique combinations of colors, button designs, fonts, backgrounds, and other design elements to disguise Gradio's appearance and create a fresh and distinct user experience.
5. **Gradio App Challenge** - Get creative with Gradio themes! Build a ✨new Gradio app✨ or 💡🚀redesign an existing one to make it visually appealing and user-friendly. Submit it to win a prize.

## How to Participate :

To participate in any track in the Themes Hackathon, first make sure that you have installed the latest version of the Gradio library (at least 3.23 or later): `pip install --upgrade gradio`

- For tracks 1 to 4, create and submit a new Theme: 
  - Step 1: Join the Gradio-Theme Party organization (this org) on Hub.
  - Step 2: Read up about Gradio's new theming capabilities here - <a href="https://gradio.app/theming-guide/" target="_blank" style="text-decoration: underline">Theming Guide</a>
  - Step 3: Create a brand new theme - Either by extending the default or other user-generated themes or creating a new theme from scratch
  - Step 4: Upload the theme to the Theme Gallery in the Hub, e.g. `my_theme.push_to_hub(repo_name="my_theme")`. Please note that you need to be logged in to Huggingface and would need to provide your Huggingface Access Token. For more information on uploading themes, see the <a href="https://gradio.app/theming-guide/#sharing-themes" target="_blank" style="text-decoration: underline">Sharing Themes</a> section of the guide.
  - Step 5: Add tags to your app's readme.md file to specify which track you are submitting in. For example, like this -  `track-1, `- track-2`, `- track-3`, `- track-4`. You can refer this Space as an example for adding tags - <a href="https://huggingface.co/spaces/keras-dreambooth/minecraft-landscape-demo/blob/main/README.md" target="_blank">Readme.md</a>.
  - Step 6: Share your themes with the community on social media and spread the word about the Hackathon 🤗

- For Track 5, the Gradio app redesign challenge, you have to <u>submit a Gradio demo</u>: 
  - Step 1: Join the Gradio-Theme Party organization on Hub.
  - Step 2: Read up about Gradio's new theming capabilities here - <a href="https://gradio.app/theming-guide/" target="_blank" style="text-decoration: underline">Theming Guide</a>
  - Step 3: Duplicate any existing Gradio demo (kudos if it is trending 👑)
  - Step 4: Add your theme effects to the demo; for example, change color, modify the font, add a background, etc.
  - Step 5: Publish the demo back on the Hub. Note that the new or redesigned <u>app must be submitted to the themes-party organization</u> so that team can find it and others can see it. This will ensure the highest visibility for your effort.
  - Step 6: Share your themes with the community on social media and spread the word about the Hackathon 🤗

## Prizes

Are you ready to win big? You're free to submit as many entries as you want. You can also submit the same Theme/Demo to multiple tracks if it meets the criteria. So, get ready to have a great time unleashing your creativity.
- For track 1, we'll add our favorite new theme to our set of default ones as a top prize 🤩. The top 3 winners, based on the number of likes, will get
  - Swag from Hugging Face merch shop: t-shirt, hoodie, or mug of your choice
  - Hugging Face PRO subscription for one year
- For tracks 2-5, we will be awarding prizes to the top 3 winners per track (HuggingFace Staff picks):
  - Swag from Hugging Face merch shop: t-shirt, hoodie, or mug of your choice
  - Hugging Face PRO subscription for one year
- 🎉 Themes Event badge on HF for all participants!
