# %%
import gradio as gr

example_generated_ape_super = "examples/generated_ape_super_resolution.jpg"
example_generated_ape = "examples/generated_ape.png"
example_stylish_ape = "examples/stylish_ape.png"
example_style_starry_night = "examples/starry_night.jpeg"
examples = [
    [example_generated_ape, example_style_starry_night, False],
    ["examples/another_generated_ape.png", "examples/The Scream (1893) by Edvard Munch.jpg", False],
    ["examples/ape02.png", "examples/Self-Portrait Without a Beard (1889) by Vincent van Gogh.jpg", True],
    ["examples/ape03.png", "examples/Oberon, Titania, and Puck with Fairies Dancing (1786) by William Blake.jpg", True],
]

ape_gen = gr.Interface.load("spaces/ykilcher/apes")
super_resolution = gr.Interface.load("spaces/akhaliq/SwinIR")
style_transfer = gr.Interface.load("spaces/aravinds1811/neural-style-transfer")

def generate_ape(num_images=1, interpolate=False):
    return ape_gen(num_images, interpolate)

def perform_style_transfer(content_image, style_image, is_super_resolution=False):
    stylish_ape = style_transfer(content_image, style_image)
    if is_super_resolution:
        stylish_ape = super_resolution(stylish_ape)
    return stylish_ape

# %%
with gr.Blocks() as demo:
    button_generate_ape = gr.Button("Generate Ape")
    
    generated_ape = gr.Image(example_generated_ape, label="Generated Ape", type="filepath")
    style_image_input = gr.Image(example_style_starry_night, label="Stylish Image", type="filepath")
    style_in_super_resolution = gr.Checkbox(True, label="Super resolution!")
    stylish_ape = gr.Image(example_stylish_ape, label="Stylish Ape")
    
    gr.Interface(
        fn=perform_style_transfer,
        inputs=[generated_ape, style_image_input, style_in_super_resolution],
        outputs=stylish_ape,
        examples=examples,
        allow_flagging="never",
    )
    with gr.Row():
        gr.Markdown("<a href='https://huggingface.co/spaces/ykilcher/apes' target='_blank'>Apes by ykilcher</a>, style transfer by <a href='https://huggingface.co/spaces/aravinds1811/neural-style-transfer' target='_blank'>Neural Style Transfer</a>, and super resolution by <a href='https://huggingface.co/spaces/akhaliq/SwinIR' target='_blank'>SwinIR</a>.")
    with gr.Row():
        gr.Markdown("![visitor badge](https://visitor-badge.glitch.me/badge?page_id=gradio-blocks_stylish_ape)")

    button_generate_ape.click(generate_ape, inputs=[], outputs=generated_ape)

demo.launch(enable_queue=False)
# %%