import gradio as gr
import random
from transformers import AutoTokenizer, AutoModelForSeq2SeqLM

author_set = {'Leopoldo Lugones', 'Nacho Buzón', 'Octavio Paz', 'Luis Cañizal de la Fuente', 'Juan de Salinas', 'Vicente Huidobro', 'Hilario Barrero',
              'Ramón de Campoamor', 'Anna Ajmátova', 'Víctor Hugo López Cancino', 'Ramón María del Valle-Inclán', 'Infantiles', 'Jorge Luis Borges',
              'Carlos Bousoño', 'Gonzalo Rojas', 'Juan Ruiz, Arcipreste de Hita', 'Rubén Izaguirre Fiallos', 'Juan Meléndez Valdés',
              'José María de Heredia', 'Jaime Sabines', 'Alejandra Pizarnik', 'María Cristina Azcona', 'Guillermo Aguirre y Fierro',
              'Miguel Ramos Carrión', 'José de Espronceda', 'Juan del Encina', 'Jorge Guillén', 'Manuel Machado', 'José Santos Chocano', 'Meira Delmar',
              'Iván Tubau', 'Tirso de Molina', 'Oliverio Girondo', 'Justo Braga', 'Consuelo Hernández', 'Belén Reyes', 'Pablo Neruda',
              'Francisco de Aldana', 'Bertolt Brecht', 'José Antonio Labordeta', 'Emilio Prados', 'Porfirio Barba Jacob', 'Leopoldo Marechal',
              'Aurelio González Ovies', 'Darío Jaramillo Agudelo', 'Víctor Botas', 'Leopoldo María Panero', 'Juan de Mena', 'Tomás de Iriarte',
              'Gabriela Mistral', 'Gonzalo de Berceo', 'Antonio Machado', 'Santiago Montobbio', 'Pedro Calderón de la Barca', 'Dionisio Ridruejo',
              'Atahualpa Yupanqui', 'Nicolás Guillén', 'Claudio Rodríguez', 'José María Blanco White', 'Gil Vicente', 'Corina Bruni', 'Gabriel Celaya',
              'Javier Alvarado', 'Rosalía de Castro', 'Gustavo Pereira', 'Miguel de Cervantes y Saavedra', 'Jorge Riechmann', 'José Juan Tablada',
              'Lope de Vega', 'Basilio Sánchez', 'Alfonso X el sabio', 'Rafael de León', 'Eunice Odio', 'Manuel Acuña', 'Víctor Jiménez',
              'José Asunción Silva', 'Omar García Ramírez', 'Luis Cernuda', 'perdón', 'Blas de Otero', 'Luis Benítez', 'Ángeles Carbajal',
              'Manuel Bretón de los Herreros', 'Baldomero Fernández Moreno', 'Luis Barahona de Soto', 'Guillermo Valencia', 'José María Hinojosa',
              'Macedonio Fernández', 'Manuel Gutiérrez Nájera', 'Alfredo Buxán', 'Salvador Novo', 'José Ángel Valente', 'José Cadalso',
              'Juan Ramón Mansilla', 'Ana Istarú', 'Juan Ramón Jiménez', 'Miguel Ángel Asturias', 'Ángel González', 'amistad', 'Alfredo Lavergne',
              'Xavier Villaurrutia', 'René Chacón Linares', 'Carolina Coronado', 'Bartolomé Leonardo de Argensola', 'Marilina Rébora',
              'Vicente Aleixandre', 'Alberto Girri', 'Juana de Ibarbourou', 'Ricardo Dávila Díaz Flores', 'Garcilaso de la Vega',
              'Lupercio Leonardo de Argensola', 'Enrique Lihn', 'Julia de Burgos', 'Mariano Brull', 'Efraín Huerta', 'Roxana Popelka',
              'Pelayo Fueyo', 'San Juan de la Cruz', 'Vicente García', 'Basilio Fernández', 'Paz Díez Taboada', 'cristianos', 'León Felipe',
              'Diana Bellessi', 'Genaro Ortega Gutiérrez', 'Cristóbal de Castillejo', 'Gioconda Belli', 'Iacyr Anderson Freitas',
              'Juan José Vélez Otero', 'Ezequiel Martínez Estrada', 'Juan de Arguijo', 'Gertrudis Gómez de Avellaneda', 'Marcos Rafael Blanco Belmonte',
              'Julio Aumente', 'Ramón López Velarde', 'para la familia', 'Antonia Álvarez Álvarez', 'José Zorrilla', 'Juan Luis Panero',
              'Teresa Palazzo Conti', 'Claribel Alegría', 'Francisco de Medrano', 'Antonio Colinas', 'Jordi Doce', 'Ismael Enrique Arciniegas',
              'Josefina Plá', 'José Agustín Goytisolo', 'Blanca Andreu', 'Enrique González Martínez', 'José García Nieto', 'Ernesto Cardenal',
              'Pedro Luis Menéndez', 'Carmen Conde Abellán', 'Salvador Rueda', 'Dulce María Loynaz', 'Odette Alonso', 'Manuel Altolaguirre',
              'Byron Espinoza', 'Francisco Álvarez', 'Vicente Gerbasi', 'César Vallejo', 'Gloria Fuertes', 'Sor Juana Inés de la Cruz',
              'Francisco de la Torre', 'Francisco Matos Paoli', 'Rubén Darío', 'Rafael Pombo', 'Mara Romero', 'José Albi', 'Francisco de Quevedo',
              'Juan de Dios Peza', 'Leopoldo Panero', 'Fernando de Herrera', 'Victoriano Crémer', 'Ana Rossetti', 'Gabriel García Márquez',
              'Teresa Domingo Català', 'Melchor de Palau', 'Miguel Rasch Isla', 'Luis Antonio de Villena', 'Mario Benedetti', 'Ramón Pérez de Ayala',
              'Antonio Plaza Llamas', 'David Escobar Galindo', 'Mario Meléndez', 'José Gorostiza', 'Delfina Acosta', 'en español', 'Delmira Agustini',
              'José Luis Piquero', 'Baltasar del Alcázar', 'Nimia Vicéns', 'Rafael Alberti', 'María Eugenia Caseiro', 'Nicomedes Santa Cruz',
              'Carlos Pellicer', 'Luis de Góngora', 'Manuel Alcántara', 'Toni García Arias', 'Antonio Fernández Lera', 'José María Pemán',
              'Dina Posada', 'Gaspar Melchor de Jovellanos', 'Alfonso Reyes', 'José María Gabriel y Galán', 'Manuel José Othón', 'Luciano Castañón',
              'Luis Alberto de Cuenca', 'Andrés Eloy Blanco', 'Luis Antonio Chávez', 'Pedro Salinas', 'Luis Palés Matos', 'Álvaro García',
              'Pablo de Rokha', 'Dámaso Alonso', 'Luis Álvarez Piner', 'Salvador García Ramírez', 'Roque Dalton', 'Gerardo Diego',
              'Felipe Benítez Reyes', 'William Shakespeare', 'José Ángel Buesa', 'Miguel Florián', 'Luis Gonzaga Urbina', 'Jesús Hilario Tundidor',
              'Amado Nervo', 'Miguel Hernández', 'Federico García Lorca', 'José Martí', 'Oscar Ferreiro', 'Pedro Miguel Lamet', 'Fray Luis de León',
              'Julio Flórez Roa', 'León de Greiff', 'Gustavo Adolfo Bécquer', 'Carlos Edmundo de Ory', 'Miguel de Unamuno', 'Manuel del Cabral',
              'Oscar Acosta', 'José Lezama Lima', 'Hernando de Acuña', 'Ángel García Aller', 'Salvador Díaz Mirón', 'Ricardo Molinari',
              'Julio Herrera y Reissig', 'Francisco Luis Bernárdez', 'Fa Claes', 'Jorge Debravo', 'Francisco de Figueroa', 'Marqués de Santillana',
              'Eugenio Florit', 'José Gautier Benítez', 'Óscar Hahn', 'Andrés Bello', 'Santa Teresa de Jesús, Sánchez de Cep', 'Juan Liscano',
              'Jorge Teillier', 'Félix María de Samaniego', 'Nicolás Fernández de Moratín', 'Juan Boscán', 'Manuel María Flores', 'Gutierre de Cetina',
              'Alfonsina Storni', 'José Luis Rey Cano', 'Jorge Manrique', 'Nicanor Parra'}

model_name = 'hackathon-pln-es/poem-gen-spanish-t5-small'
tokenizer = AutoTokenizer.from_pretrained(model_name)
model = AutoModelForSeq2SeqLM.from_pretrained(model_name)


def make_poem(author, sentiment, words, text):
  num_lines=5
  poem = text
  prev_output = ''
  l_words = [x.strip() for x in words.split(',')]

  # Add empty strings to words
  if num_lines > len(l_words):
    diff = num_lines - len(l_words)
    l_words += [''] * diff

  random.shuffle(l_words)

  for i in range(num_lines):
    word = l_words[i]
    if word == '':
      input_text = f"""poema: estilo: {author} && sentimiento: {sentiment} && texto: {poem} """
    else:
      input_text = f"""poema: estilo: {author} && sentimiento: {sentiment} && palabras: {word} && texto: {poem} """
    inputs = tokenizer(input_text, return_tensors="pt")

    outputs = model.generate(inputs["input_ids"],
                            do_sample = True,
                            max_length = 30,
                            repetition_penalty = 20.0,
                            top_k = 50,
                            top_p = 0.92)
    detok_outputs = [tokenizer.decode(x, skip_special_tokens=True) for x in outputs]
    pre_output = detok_outputs[0]

    poem += '\n' + pre_output
  # audio = tts_es(poem)
  # return poem, audio
  return poem


def poem_generate(author, sentiment, words, text):
    poem_txt = make_poem(author, sentiment, words, text)
    # Pending: Translate poem to English, so that text can be the input of the latentdiffussion
    poem_img = poem_to_image(poem_txt[-100:])
    return poem_txt, poem_img


def poem_to_image(poem):
    print(['poem_to_image', 'start'])
    poem = " ".join(poem.split('\n'))
    poem = poem + " oil on canvas."
    steps, width, height, images, diversity = '50', '256', '256', '1', 15
    img = gr.Interface.load("spaces/multimodalart/latentdiffusion")(poem,
                                                                    steps, width, height, images, diversity)[0]
    print(['poem_to_image', 'end'])
    return img


def debug_fn(*args):
    return ', '.join(args), 'salida dos'


with gr.Blocks() as demo:
    gr.Markdown(
        """This space is taking as a base the [Spanish Poem Generation](https://huggingface.co/spaces/hackathon-pln-es/poem-generation-es) created during the First Spanish Hackathon of NLP.
    
    A [t5-small](https://huggingface.co/hackathon-pln-es/poem-gen-spanish-t5-small) was trained with this [dataset](https://huggingface.co/datasets/hackathon-pln-es/spanish-poetry-dataset) of spanish poems. 
    
    In this space you will be able to tune some parameters, to obtain a poem and an illustration 🎨 generated with Latent Diffusion Art space by [Multimodalart](https://huggingface.co/spaces/multimodalart/latentdiffusion).
    
    With ❤️ by [Alberto Carmona Barthelemy](https://huggingface.co/milyiyo) from 🇨🇺.
    """)
    with gr.Row():
        with gr.Column():
            input_author = gr.Dropdown(
                sorted(author_set), type="value", label='Nombre del autor')
            input_sentiment = gr.Radio(
                ['positivo', 'negativo'], label='Sentimiento del texto generado')
            input_include_words = gr.Textbox(
                lines=1, placeholder='palabra_1, palabra_2, ..., palabra_n', label='Palabras que desea incluir')
            input_initial_text = gr.Textbox(
                lines=4, placeholder='texto inicial', label='Texto inicial')
            b1 = gr.Button("Generate Poem & Illustration")
            
        output_poem_txt = gr.Textbox(lines=7, label='Poema generado')
        output_image = gr.Image(type="filepath", shape=(256, 256))

    b1.click(poem_generate, inputs=[input_author, input_sentiment, input_include_words, input_initial_text], outputs=[output_poem_txt, output_image])

demo.launch(enable_queue=True, debug=True)
