import requests
from pprint import pprint
from time import sleep

api_key = 'YOUR_API_KEY'
audio_url = 'https://listentogenius.com/recordings4/Innocence.mp3'

def audio_to_text(api_key, audio_url):
  endpoint = "https://api.assemblyai.com/v2/transcript"

  headers = {
      'authorization': api_key, 
      'content-type': 'application/json'
  }

  body = {
      'audio_url': audio_url
  }

  # 1. Submitting Files for Transcription

  res = requests.post(endpoint, json=body, headers=headers)
  transcript_id = res.json().get('id')
  print(transcript_id)

  # 2. Getting the Transcription Result

  endpoint_full = f"https://api.assemblyai.com/v2/transcript/{transcript_id}"
  status = 'processing'
  while transcript_id and status != 'completed':
      print('Getting the transcription result ....')
      sleep(5)
      res_text = requests.get(endpoint_full, headers=headers)
      status = res_text.json().get('status')
  data = res_text.json().get('text')

  return data


import gradio as gr

demo = gr.Blocks()

with demo:
    gr.Markdown(
    """
    # Convert Audio files to Text files using AssemblyAI. 
    ### Get AssemblyAI API Key from here https://app.assemblyai.com/
    """)
    inp = [gr.Textbox(label='API Key', placeholder="What is your API Key?"), gr.Textbox(label='Audio File URL', placeholder="Audio file URL?")]
    out = gr.Textbox(label='Output')
    text_button = gr.Button("Flip")

    text_button.click(audio_to_text, inputs=inp, outputs=out)

demo.launch()