import subprocess
from transformers import AutoModelForCausalLM, AutoTokenizer
import torch

tokenizer = AutoTokenizer.from_pretrained("ericzhou/DialoGPT-Medium-Rick_v2")
model = AutoModelForCausalLM.from_pretrained("ericzhou/DialoGPT-Medium-Rick_v2")


def predict(input, history=[]):
    # tokenize the new input sentence
    new_user_input_ids = tokenizer.encode(
        input + tokenizer.eos_token, return_tensors="pt"
    )

    # append the new user input tokens to the chat history
    bot_input_ids = torch.cat([torch.LongTensor(history), new_user_input_ids], dim=-1)

    # generate a response
    history = model.generate(
        bot_input_ids, max_length=1000, pad_token_id=tokenizer.eos_token_id
    ).tolist()

    # convert the tokens to text, and then split the responses into the right format
    response = tokenizer.decode(history[0]).split("<|endoftext|>")
    response = [
        (response[i], response[i + 1]) for i in range(0, len(response) - 1, 2)
    ]  # convert to tuples of list
    return response, history


import gradio as gr

demo = gr.Blocks()

with demo:
    gr.Markdown(
        """
    <center>    
    <img src="https://huggingface.co/spaces/Gradio-Blocks/RickandMorty-BlockParty/resolve/main/img/img1.png" alt="dialog" width="250" height="250">
    
    # Let's start the party with Rick & Morty
    Chat with Morty by typing in the input box below.
    </center>
    """
    )
    state = gr.Variable(value=[])
    chatbot = gr.Chatbot(color_map=("#00ff7f", "#00d5ff"))
    text = gr.Textbox(
        label="Talk to Morty here... (press enter to submit)",
        value="How are you?",
        placeholder="What is your name?",
        max_lines=1,
    )

    text.submit(predict, [text, state], [chatbot, state])
    text.submit(lambda x: "", text, text)

demo.launch()
