---
title: README
emoji: 💻
colorFrom: indigo
colorTo: gray
sdk: static
pinned: false
---

<div class="grid lg:grid-cols-2 gap-x-4">
   <h2 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">
        Welcome to the <a href="https://gradio.app/" target="_blank" style="text-decoration: underline">Gradio</a> Blocks Party 🥳  
   </h2>
   <h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Join organization by clicking <a href="https://huggingface.co/organizations/Gradio-Blocks/share/YyEmWbViPRZypvGSnZzGxmKEnJqnOqgKKx" style="text-decoration: underline">here</a></h3>
    <h4 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold"><a href="https://huggingface.co/spaces/Gradio-Blocks/Leaderboard" style="text-decoration: underline">Live Blocks Party Leaderboard</a></h4>
   <img class="lg:col-span-2" src="https://huggingface.co/spaces/Gradio-Blocks/README/resolve/main/banner.png" alt="Gradio Banner" style="margin:10px">
   <p class="lg:col-span-2">
    We are happy to invite you to the Gradio Blocks Party - a community event in which we will create <b>interactive demos</b> for state-of-the-art machine learning models. Demos are powerful because they allow anyone — not just ML engineers — to try out models in the browser, give feedback on predictions, identify trustworthy models. The event will take place from <b>May 17th to 31st</b>. We will be organizing this event on <a href="https://huggingface.co/Gradio-Blocks" target="_blank" style="text-decoration: underline">Hugging Face</a> and the <a href="https://discord.com/invite/feTf9x3ZSB" target="_blank" style="text-decoration: underline">Hugging Face discord server</a>, check the gradio channel for staying up to date with the event. Prizes will be given at the end of the event, see the <a href="#Prizes" target="_blank" style="text-decoration: underline">Prizes section</a> </p><br />
   
   <p class="lg:col-span-2"> We will be building demos using the new Gradio Blocks API. Blocks allows you to build web-based demos in a flexible way using the <a href="https://www.gradio.app">Gradio library</a>. Gradio is a popular choice for building demos for machine learning models, as it allows you to create web-based UIs all in Python. For example, here is a UI for Dall-E Mini using Gradio Blocks:
   </p>
   <br />
   <video class="lg:col-span-2"
 controls autoplay>
   <source src="https://huggingface.co/spaces/Gradio-Blocks/README/resolve/main/dalle-short.mov" type="video/mp4">
   Your browser does not support the video tag.
   </video>
   <br />   
   <details class="lg:col-span-2">
   <h3  class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">More About Gradio</h3>
   <p class="lg:col-span-2">
     Gradio is a Python library that allows you to quickly build web-based machine learning demos, data science dashboards, or other kinds of web apps, entirely in Python. These web apps can be launched from wherever you use Python (jupyter notebooks, colab notebooks, Python terminal, etc.) and shared with anyone instantly using Gradio's auto-generated share links. To learn more about Gradio see the Getting Started Guide:  <a href="https://gradio.app/getting_started/" target="_blank" style="text-decoration: underline">https://gradio.app/getting_started/</a> and the new Course on Huggingface about Gradio:  <a href="https://huggingface.co/course/chapter9/1?fw=pt" style="text-decoration: underline" target="_blank">Gradio Course</a>.
   </p>
   <br />
   <p class="lg:col-span-2">Gradio can be installed via pip and comes preinstalled in Hugging Face Spaces, the latest version of Gradio can be set in the README in spaces by setting the sdk_version, for example <code>sdk_version: 3.0.2</code></p>
   <br />
   <p class="lg:col-span-2">To install gradio locally, simply run: <code>pip install gradio</code> </p>
   <br />
   <h3  class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Gradio Blocks</h3>
   <p class="lg:col-span-2">
     <code>gradio.Blocks</code> is a low-level API that allows you to have full control over the data flows and layout of your application. You can build very complex, multi-step applications using Blocks.
     If you have already used gradio.Interface, you know that you can easily create fully-fledged machine learning demos with just a few lines of code. The Interface API is very convenient but in some cases may not be sufficiently flexible for your needs. For example, you might want to:
   </p>
   <ul class="lg:col-span-2" style="list-style: circle inside">
         <li class="my-4">Group together related demos as multiple tabs in one web app</li>
         <li class="my-4">Change the layout of your demo instead of just having all of the inputs on the left and outputs on the right</li>
         <li class="my-4">Have multi-step interfaces, in which the output of one model becomes the input to the next model, or have more flexible data flows in general</li>
         <li class="my-4">Change a component's properties (for example, the choices in a Dropdown) or its visibilty based on user input</li>
   </ul>
   <br />
   <p class="lg:col-span-2">to learn more about Blocks see the guide <a href="   https://www.gradio.app/introduction_to_blocks/" target="_blank" style="text-decoration: underline">https://www.gradio.app/introduction_to_blocks/</a></p> 
   <br />
   <h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">What is Hugging Face Spaces?</h2>
   <p class="lg:col-span-2">Spaces are a simple way to host ML demo apps directly on your profile or your organization’s profile on Hugging Face. This allows you to create your ML portfolio, showcase your projects at conferences or to stakeholders, and work collaboratively with other people in the ML ecosystem. Learn more about spaces <a href="https://huggingface.co/docs/hub/spaces" style="text-decoration: underline">here</a>.</p>
   <br />
   <h3  class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">How Does Gradio and Hugging Face work together?</h3>
   <p class="lg:col-span-2">
      Hugging Face Spaces is a free hosting option for Gradio demos. Spaces comes with 3 SDK options: Gradio, Streamlit and Static HTML demos. Spaces can be public or private and the workflow is similar to github repos. There are over 2000+ Gradio spaces currently on Hugging Face. Learn more about spaces here:  <a href="https://huggingface.co/docs/hub/spaces" target="_blank" style="text-decoration: underline">https://huggingface.co/docs/hub/spaces</a> 
   </p>
   <br />
   <h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Event Plan</h3>
   <ul class="lg:col-span-2" style="list-style: circle inside">
      <li class="my-4">1. Learning about <a href="https://gradio.app/" target="_blank" style="text-decoration: underline">Gradio</a> and the new <a href="https://www.gradio.app/introduction_to_blocks/" target="_blank" style="text-decoration: underline">Blocks API</a></li>
      <li class="my-4">2. Building your own Blocks demo using <a href="https://gradio.app/" target="_blank" style="text-decoration: underline">Gradio</a> and <a href="https://huggingface.co/spaces" target="_blank" style="text-decoration: underline">Hugging Face Spaces</a></li>
      <li class="my-4">3. Submitting your demos on Spaces to the <a href="https://huggingface.co/organizations/Gradio-Blocks/share/YyEmWbViPRZypvGSnZzGxmKEnJqnOqgKKx" target="_blank" style="text-decoration: underline">Gradio Blocks Party Organization</a> <b>(Feel free to submit multiple demos)</b></li>
      <li class="my-4">4. Share your blocks demo with others and get likes ❤️</li>
      <li class="my-4">5. Win Prizes!</li>
   </ul>
   <br />
   <h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Some examples using Blocks</h3>
   <img class="my-8 lg:col-span-2" alt="mindseye-lite" src="https://huggingface.co/spaces/Gradio-Blocks/README/resolve/main/mindseye-lite.png">
  <ul class="lg:col-span-2" style="list-style: circle inside">
      <li  class="my-4"><a href="https://huggingface.co/spaces/dalle-mini/dalle-mini" style="text-decoration: underline">dalle-mini</a> (<a href="https://huggingface.co/spaces/dalle-mini/dalle-mini/blob/main/app/gradio/app.py" style="text-decoration: underline">Code</a>)</li>
      <li  class="my-4"><a href="https://huggingface.co/spaces/multimodalart/mindseye-lite" style="text-decoration: underline">mindseye-lite</a> (<a href="https://huggingface.co/spaces/multimodalart/mindseye-lite/blob/main/app.py" style="text-decoration: underline">Code</a>)</li>
      <li  class="my-4"><a href="https://huggingface.co/spaces/akhaliq/ArcaneGAN-blocks" style="text-decoration: underline">ArcaneGAN-blocks</a> (<a href="https://huggingface.co/spaces/akhaliq/ArcaneGAN-blocks/blob/main/app.py" style="text-decoration: underline">Code</a>)</li>
      <li  class="my-4"><a href="https://huggingface.co/spaces/merve/gr-blocks" style="text-decoration: underline">gr-blocks</a> (<a href="https://huggingface.co/spaces/merve/gr-blocks/blob/main/app.py" style="text-decoration: underline">Code</a>)</li>
      <li  class="my-4"><a href="https://huggingface.co/spaces/osanseviero/tortoisse-tts" style="text-decoration: underline">tortoisse-tts</a> (<a href="https://huggingface.co/spaces/osanseviero/tortoisse-tts/blob/main/app.py" style="text-decoration: underline">Code</a>)</li>
      <li  class="my-4"><a href="https://huggingface.co/spaces/osanseviero/tortoisse-tts" style="text-decoration: underline">CaptchaCracker</a> (<a href="https://huggingface.co/spaces/akhaliq/CaptchaCracker/blob/main/app.py" style="text-decoration: underline">Code</a>)</li>
   </ul>
   <br />
   <h3 class="lg:col-span-2" style="font-size:20px; font-weight:bold">To participate in the event</h3>
   <ul class="lg:col-span-2" style="list-style: circle inside">
      <li class="my-4">Join the organization for Blocks event (so that you can add your demo to the Blocks Party org): <a href="https://huggingface.co/organizations/Gradio-Blocks/share/YyEmWbViPRZypvGSnZzGxmKEnJqnOqgKKx" style="text-decoration: underline">https://huggingface.co/organizations/Gradio-Blocks/share/YyEmWbViPRZypvGSnZzGxmKEnJqnOqgKKx</a></li>
      <li class="my-4">Join the discord to keep up with announcements or ask questions: <a href="https://discord.com/invite/feTf9x3ZSB" style="text-decoration: underline">https://discord.com/invite/feTf9x3ZSB</a> </li>      <li class="my-4">Start building cool demos!</li>

      
   </ul>
   <br />
   <h3 class="lg:col-span-2">Potential ideas for creating spaces: </h3>
   <ul class="lg:col-span-2" style="list-style: circle inside;padding-left: 40px;">
      <li class="my-4">Trending papers from <a href="https://paperswithcode.com/" style="text-decoration: underline">https://paperswithcode.com/</a></li>
      <li class="my-4">Models from huggingface model hub: <a href="https://huggingface.co/models" style="text-decoration: underline">https://huggingface.co/models</a></li>
      <li class="my-4">Models from other model hubs
         <ul class="lg:col-span-2" style="list-style: circle inside;padding-left: 40px;">
            <li class="my-4">Tensorflow Hub: see example Gradio demos at <a href="https://huggingface.co/tensorflow" style="text-decoration: underline">https://huggingface.co/tensorflow</a></li>
            <li class="my-4">Pytorch Hub: see example Gradio demos at <a href="https://huggingface.co/pytorch" style="text-decoration: underline">https://huggingface.co/pytorch</a></li>
            <li class="my-4">ONNX model Hub: see example Gradio demos at <a href="https://huggingface.co/onnx" style="text-decoration: underline">https://huggingface.co/onnx</a></li>
            <li class="my-4">PaddlePaddle Model Hub: see example Gradio demos at <a href="https://huggingface.co/PaddlePaddle" style="text-decoration: underline">https://huggingface.co/PaddlePaddle</a></li>
         </ul>
      </li>
      <li class="my-4">Try your own ideas!</li>
   </ul>
   <br />
   <h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold" id="Prizes">Prizes</h3>
  <ul class="lg:col-span-2" style="list-style: circle inside;padding-left: 40px;">
   <li class="my-4">1st place winner based on likes<ul class="lg:col-span-2" style="list-style: circle inside;padding-left: 40px;">
   <li class="my-4"><a href="https://huggingface.co/pricing">Hugging Face PRO subscription</a> for 1 year</li>
   <li class="my-4">We'll embedding your demo in the Gradio website!</li>
   </ul>
   </li>
   <li class="my-4">Top 10 winners based on likes<ul class="lg:col-span-2" style="list-style: circle inside;padding-left: 40px;">
   <li class="my-4">Swag from <a href="https://huggingface.myshopify.com/">Hugging Face merch shop</a>: t-shirt, hoodie, or mug of your choice</li>
   </ul>
   </li>
   <li class="my-4">Top 25 winners based on likes<ul class="lg:col-span-2" style="list-style: circle inside; padding-left: 40px;">
   <li class="my-4"><a href="https://huggingface.co/pricing">Hugging Face PRO subscription</a> for 1 month</li>
   </ul>
   </li>
   <li class="my-4">Blocks event badge on HF for all participants!</li>
   </ul>
   <br />
   <h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Other Potential Prizes</h3>
   <ul class="lg:col-span-2" style="list-style: circle inside">
      <li class="my-4">Staff Picks</li>
      <li class="my-4">Most liked Spaces</li>
      <li class="my-4">Community Pick (voting)</li>
      <li class="my-4">Most Creative Space (voting)</li>
      <li class="my-4">Most Educational Space (voting)</li>
      <li class="my-4">CEO's pick (one prize for a particularly impactful demo), picked by @clem</li>
      <li class="my-4">CTO's pick (one prize for a particularly technically impressive demo), picked by @julien</li>
   </ul>
   <h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Creating a Gradio demo on Hugging Face Spaces</h3>
   <p class="lg:col-span-2">Once a model has been picked from the choices above, you can share a model in a Space using Gradio. Read more about how to add Gradio spaces: <a href="https://huggingface.co/blog/gradio-spaces" style="text-decoration: underline">https://huggingface.co/blog/gradio-spaces</a></p>
   <p class="lg:col-span-2">Steps to add Gradio Spaces to the Gradio Blocks Party org</p>
   <ul class="lg:col-span-2" style="list-style: circle inside">
      <li class="my-4">Create a account on Hugging Face</li>
      <li class="my-4">Join the Gradio Blocks Party Organization by clicking "Join Organization" button in the organization page or using the shared link above</li>
      <li class="my-4">Once your request is approved, add your space using the Gradio SDK and share the link with the community!
   </li>
   </ul>
  <h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">LeaderBoard for Most Popular Blocks Event Spaces</h3>
  <p class="lg:col-span-2">See the <a href="https://huggingface.co/spaces/Gradio-Blocks/Leaderboard" target="_blank" style="text-decoration:underline; font-weight:bold">Live Blocks Party Leaderboard</a></p>
  </details>
</div>