import gradio as gr

from transformers import pipeline

def text_pipelines(text_txt, text_pipes):
   if text_pipes == "Translate En to Fr":
      en_fr_translator = pipeline("translation_en_to_fr")
      output = en_fr_translator(f"{text_txt}")[0]["translation_text"]
   elif text_pipes == "Text Generation":
      text_generation = pipeline("text-generation")
      output = text_generation(f"{text_txt}")[0]["generated_text"]   
   elif text_pipes == "Sentiment Analysis":
      sentiment_analysis = pipeline("sentiment-analysis")
      output = sentiment_analysis(f"{text_txt}")
   return output
   
def cat_images(cat_slider):
   if cat_slider < 10:
      images = ["./images/dog1.jpg", "./images/dog2.jpg"]
   if cat_slider >= 10:
      images = ["./images/cat1.jpg", "./images/cat2.jpg", "./images/cat3.jpg"]
   return images
     
with gr.Blocks() as Blocks:
   with gr.Row():
      gr.Markdown("<h1>🤗 Hugging Face Pipelines 🤗</h1> <h2>🥳🥳 Welcome to the block party! 🥳🥳</h2>")
      
   with gr.Row():
     with gr.Column():
        gr.Markdown("<br><br><br><br>")
        with gr.Tabs():
           with gr.TabItem("Audio Classification"):
              gr.Markdown("<h3>🔊Audio Classification</h3><p>Classifies your audio!</p><p>You could: Label emotions, such as happy or sad.😊😢</p>")
           with gr.TabItem("Automatic Speech Recognition"):
              gr.Markdown("<h3>💬Automatic Speech Recognition</h3><p>Recognizes speech automatically!</p><p>You could: Create transcripts. 📃</p>")
           with gr.TabItem("Image Segmentation"):
              gr.Markdown("<h3>🖼️Image Segmentation</h3><p>Segments images!</p><p>You could: Highlight the area that has a cat</p")
        gr.Markdown("<br><br><p>There are all kinds of pipelines: image, text, audio!</p><p>⬇️ Try some of them out below ⬇️</p>")    
     with gr.Column():
        gr.Markdown("<br><br>")   
     with gr.Column():
        with gr.Tabs():
           with gr.TabItem("What's a Pipeline?!"):
              gr.Markdown("Easy mode! Use the pipeline() to streamline everything in like 4 lines of code. It's even smart enough to pick a model for you if you want.  🤗")
           with gr.TabItem("What's Gradio?"):
              gr.Markdown("The way to make layouts super quickly! You can add dropdown boxes, radio buttons, checkboxes and more which will be able to change the inputs to your functions.")
        with gr.Tabs():
           with gr.TabItem("Block Party!"):
              gr.Markdown("<p>This was created during Hugging Face's Block Party to celebrate the release of Gradio's new block function.</p><p>The app was created using a block with 4 rows, and the info box you are reading was made using Gradio Tabs!</p><p>Thank you ever so much for your likes! ❤️</p>")              
           with gr.TabItem("Cat Tax"):
              cat_slider = gr.Slider(0, 100, label="Percentage you like cats:")
              cats_but = gr.Button("Show cute cats!")
              gallery = gr.Gallery() 
        
   with gr.Row():
      gr.Markdown("<h1>🚀 Test Out Some Text Pipelines! 🚀")     
      
   with gr.Row():
      text_txt = gr.Textbox("Enter something fun here!", label="1. Type some text:")
      text_pipes = gr.Dropdown(["Translate En to Fr", "Text Generation", "Sentiment Analysis"], label="2. Pick your Pipeline:")
      go_but = gr.Button("3. It's go time!")
      text = gr.Textbox("Hit the go button to see results here", label="4. See the output!")
   
   
   cats_but.click(cat_images, inputs=cat_slider, outputs=gallery)
   go_but.click(text_pipelines, inputs=[text_txt, text_pipes], outputs=text)
Blocks.launch()