from transformers import AutoTokenizer, AutoModelForCausalLM
import torch
import gradio as gr

tokenizer = AutoTokenizer.from_pretrained("natdon/DialoGPT_Michael_Scott")
model = AutoModelForCausalLM.from_pretrained("natdon/DialoGPT_Michael_Scott")

chat_history_ids = None
step = 0


def predict(input, chat_history_ids=chat_history_ids, step=step):
    # encode the new user input, add the eos_token and return a tensor in Pytorch
    new_user_input_ids = tokenizer.encode(
        input + tokenizer.eos_token, return_tensors='pt')

    # append the new user input tokens to the chat history
    bot_input_ids = torch.cat(
        [chat_history_ids, new_user_input_ids], dim=-1) if step > 0 else new_user_input_ids

    # generated a response while limiting the total chat history to 1000 tokens,
    chat_history_ids = model.generate(
        bot_input_ids, max_length=1000,
        pad_token_id=tokenizer.eos_token_id,
        no_repeat_ngram_size=3,
        do_sample=True,
        top_k=100,
        top_p=0.7,
        temperature=0.8
    )
    step = step + 1
    output = tokenizer.decode(
        chat_history_ids[:, bot_input_ids.shape[-1]:][0], skip_special_tokens=True)
    return output


demo = gr.Blocks()

with demo:
    gr.Markdown(
        """
  <center>    
  <img src="https://media3.giphy.com/media/l0amJzVHIAfl7jMDos/giphy.gif" alt="dialog" width="250" height="250">
  
  ## Speak with Michael by typing in the input box below.
  </center>
  """
    )

    with gr.Row():
        with gr.Column():
            inp = gr.Textbox(
                label="Enter text to converse with Michael here:",
                lines=1,
                max_lines=1,
                value="Wow this is hard",
                placeholder="What do you think of Toby?",
            )
            btn = gr.Button("Submit")
        out = gr.Textbox(lines=3)
    # btn = gr.Button("Submit")
    inp.submit(fn=predict, inputs=inp, outputs=out)
    btn.click(fn=predict, inputs=inp, outputs=out)

demo.launch()
