# font management
# author: Zeng Yifu（曾逸夫）
# creation time: 2022-05-01
# email: zyfiy1314@163.com
# project homepage: https://gitee.com/CV_Lab/gradio_yolov5_det

import os
import sys
from pathlib import Path

import wget
from rich.console import Console

ROOT_PATH = sys.path[0] # Project root directory

# Chinese, English, Russian, Spanish, Arabic, Korean
fonts_list = ["SimSun.ttf", "TimesNewRoman.ttf", "malgun.ttf"] # font list
fonts_suffix = ["ttc", "ttf", "otf"] # font suffix

data_url_dict = {
    "SimSun.ttf": "https://gitee.com/CV_Lab/gradio_yolov5_det/attach_files/1053539/download/SimSun.ttf",
    "TimesNewRoman.ttf": "https://gitee.com/CV_Lab/gradio_yolov5_det/attach_files/1053537/download/TimesNewRoman.ttf",
    "malgun.ttf": "https://gitee.com/CV_Lab/gradio_yolov5_det/attach_files/1053538/download/malgun.ttf",}

console = Console()


# create font library
def add_fronts(font_diff):

    global font_name

    for k, v in data_url_dict.items():
        if k in font_diff:
            font_name = v.split("/")[-1] # font name
            Path(f"{ROOT_PATH}/fonts").mkdir(parents=True, exist_ok=True) # Create a directory

            file_path = f"{ROOT_PATH}/fonts/{font_name}" # font path

            try:
                # Download font file
                wget.download(v, file_path)
            except Exception as e:
                print("Path error! Program ended!")
                print(e)
                sys.exit()
            else:
                print()
                console.print(f"{font_name} [bold green]font file download complete![/bold green] has been saved to: {file_path}")


# Determine the font file
def is_fonts(fonts_dir):
    if os.path.isdir(fonts_dir):
        # if the font library exists
        f_list = os.listdir(fonts_dir) # local font library

        font_diff = list(set(fonts_list).difference(set(f_list)))

        if font_diff != []:
            # font does not exist
            console.print("[bold red] font does not exist, loading...[/bold red]")
            add_fronts(font_diff) # Create a font library
        else:
            console.print(f"{fonts_list}[bold green]font already exists![/bold green]")
    else:
        # The font library does not exist, create a font library
        console.print("[bold red]font library does not exist, creating...[/bold red]")
        add_fronts(fonts_list) # Create a font library