import gradio as gr
import requests
import os 

# GPT-J-6B API
API_URL = "https://api-inference.huggingface.co/models/EleutherAI/gpt-j-6B"
HF_TOKEN = os.environ["HF_TOKEN"]
headers = {"Authorization": f"Bearer {HF_TOKEN}"}

prompt = """
word: risk
poem using word: And then the day came,
when the risk
to remain tight
in a bud
was more painful
than the risk
it took
to blossom.

word: bird
poem using word: She sights a bird, she chuckles
She flattens, then she crawls
She runs without the look of feet
Her eyes increase to Balls.

word: """

examples = [["river"], ["night"], ["trees"],["table"],["laughs"]]


def poem_generate(word):

  p = prompt + word.lower() + "\n" + "poem using word: "
  print(f"*****Inside poem_generate - Prompt is :{p}")
  json_ = {"inputs": p,
            "parameters":
            {
            "top_p": 0.9,
          "temperature": 1.1,
          "max_new_tokens": 50,
          "return_full_text": False
          }}
  response = requests.post(API_URL, headers=headers, json=json_)
  output = response.json()
  print(f"If there was an error? Reason is : {output}")
  output_tmp = output[0]['generated_text']
  print(f"GPTJ response without splits is: {output_tmp}")
  #poem = output[0]['generated_text'].split("\n\n")[0] # +"."
  if "\n\n" not in output_tmp:
    if output_tmp.find('.') != -1:
      idx = output_tmp.find('.')
      poem = output_tmp[:idx+1]
    else:
      idx = output_tmp.rfind('\n')
      poem = output_tmp[:idx]
  else:
    poem = output_tmp.split("\n\n")[0] # +"."
  poem = poem.replace('?','')
  print(f"Poem being returned is: {poem}")
  return poem

def poem_to_image(poem):
  print("*****Inside Poem_to_image")
  poem = " ".join(poem.split('\n'))
  poem = poem + " oil on canvas."
  steps, width, height, images, diversity = '50','256','256','1',15
  img = gr.Interface.load("spaces/multimodalart/latentdiffusion")(poem, steps, width, height, images, diversity)[0]
  return img

demo = gr.Blocks()

with demo:
  gr.Markdown("<h1><center>Generate Short Poem along with an Illustration</center></h1>")
  gr.Markdown(
        """Enter a single word you would want GPTJ-6B to write Poetry 🎤 on. A Space by [Yuvraj Sharma](https://huggingface.co/ysharma)."""
        )
  gr.Markdown("""<div>Generate an illustration 🎨 provided by Latent Diffusion model.</div><div>GPJ-6B is a 6 Billion parameter autoregressive language model. It generates the Poem based on how it has been 'prompt-engineered' 🤗 The complete text of generated poem then goes in as a prompt to the amazing Latent Diffusion Art space by <a href='https://huggingface.co/spaces/multimodalart/latentdiffusion' target='_blank'>Multimodalart</a>.</div>Please note that some of the Poems/Illustrations might not look at par, and well, this is what happens when you can't 'cherry-pick' and post 😁 <div> Some of the example words that you can use are 'river', 'night', 'trees', 'table', 'laughs' or maybe on similar lines to get best results!"""
    )
  with gr.Row():
    input_word = gr.Textbox(placeholder="Enter a word here to create a Poem on..")
    poem_txt = gr.Textbox(lines=7)
    output_image = gr.Image(type="filepath", shape=(256,256))
  
  b1 = gr.Button("Generate Poem")
  b2 = gr.Button("Generate Image")

  b1.click(poem_generate, input_word, poem_txt)
  b2.click(poem_to_image, poem_txt, output_image)
  #examples=examples

demo.launch(enable_queue=True, debug=True)