import openai
import numpy as np
import os
import json
import gradio as gr
 
openai.api_key = os.environ["api_key"]
engine = "code-davinci-002"


def happytt(temperature,max_tokens,text,stop):
  try:
    s = json.loads(stop)
    response = openai.Completion.create(
      engine=engine,
      prompt=text,
      temperature=temperature,
      max_tokens=max_tokens,
      top_p=1,
      frequency_penalty=0,
      presence_penalty=0,
      stop=s
    )
  except json.JSONDecodeError:
    response = openai.Completion.create(
      engine=engine,
      prompt=text,
      temperature=temperature,
      max_tokens=max_tokens,
      top_p=1,
      frequency_penalty=0,
      presence_penalty=0
    )

  return response.choices[0].text


title = "OpenAI Codex"
description = '''OpenAI Codex is an artificial intelligence model developed by OpenAI. 
It parses natural language and generates code in response. 
It is used to power GitHub Copilot, a programming autocompletion 
tool developed for  Code generation.

Try following prompts and tweak temperatures  in following links -

https://www.pragnakalp.com/experimenting-with-openai-codex/

https://betterprogramming.pub/i-beta-tested-openais-codex-and-the-results-are-spooky-good-e282a1874c79

https://beta.openai.com/examples?category=code

Built by  [mohammed arsalan](https://www.linkedin.com/in/sallu-mandya/)'''
 
 
iface = gr.Interface( happytt,[ gr.Slider(0, 1, step=0.1),gr.Slider(150, 4000, step=1),
                               gr.Textbox(type='str',   
                                                 label="input prompt"),
                               gr.Textbox(type='str',   
                                                 label="list of tokens, when to finish generating",
                                                 placeholder='["<code>", "import"]')],"text", title = title, description = description )
iface.launch(debug=True)