import gradio as gr
from fastai import *
from fastai.vision.all import *

import pathlib
plt = platform.system()
if plt == 'Linux': pathlib.WindowsPath = pathlib.PosixPath

learn_inf = load_learner("export.pkl")

def predict_mood(img):

    pred, pred_idx, probs = learn_inf.predict(img)
    return f'Prediction: {pred}; Probability: {probs[pred_idx]:.04f}'

gr.inputs.Image(tool=False, optional=False)
webpage = gr.Interface(fn=predict_mood, inputs=gr.inputs.Image(tool=False, optional=False), outputs="text", title="Women's Mood Detector", live=True, theme="dark-peach", description="It detects wether the woman is Angry, Happy, or Sad.", examples=[["example1.jpg"], ["example2.jpg"], ["example3.jpg"]])
webpage.launch()