---
title: Hand Written Text Digit Recognition
emoji: 📉
colorFrom: blue
colorTo: red
sdk: streamlit
sdk_version: 1.28.1
app_file: app.py
pinned: false
license: mit
---

Check out the configuration reference at https://huggingface.co/docs/hub/spaces-config-reference

# Task : Handwritten Text Digit Recognition using streamlit

## Problem Statement:

Handwritten digit recognition is a fundamental task in machine learning and computer vision that involves identifying and classifying individual digits (0-9) that have been handwritten. This task plays a crucial role in various applications across different domains.
This project aims to develop a handwritten digit recognition system using deep learning techniques. It involves building and training models that can accurately classify handwritten digits.

## Importance and Use Cases:

1. Finance: Automatic check reading, where handwritten numbers on checks are recognized to process financial transactions efficiently.

2. Postal Services: ZIP code recognition, aiding postal services in sorting and delivering mail accurately.

3. Data Entry and Forms: Digit extraction in forms, simplifying data entry processes and reducing errors in handwritten information.

4. Educational Tools: Handwritten digit recognition is also used in educational tools to provide interactive learning experiences, such as math and number games.

5. OCR Systems: It is a crucial component of Optical Character Recognition (OCR) systems used for digitizing printed and handwritten text.

## Challenges:

Handwritten digit recognition presents several challenges, including variations in writing styles, different writing tools, noise in scanned images, and variations in digit orientation and size.


## Overview

This project aims to implement a Handwritten Digit Recognition system. We have trained a machine learning model and loaded the model weights (model_weights.pth). By running the app.py script, you can interact with the application.

## Usage Instructions

Follow these steps to use the application:

1. **Installation**: Ensure you have installed all the required libraries and packages.

2. **Model Setup**: We've trained a model and saved its weights in model_weights.pth. Make sure you have this file in your project directory.

3. **Run the App**: Execute the app.py script to launch the interactive application.

4. **Select Colors**: Use the application to choose the background color and stroke color. You can also load an input image or draw a digit.

5. **Digit Prediction**: The model will predict the drawn digit or the digit in the loaded image.

Enjoy using the Handwritten Digit Recognition app!



