import gradio as gr
from transformers import AutoTokenizer, AutoModelForSeq2SeqLM

tokenizer = AutoTokenizer.from_pretrained("Gorilla115/t5-shakespearify-lite")

model = AutoModelForSeq2SeqLM.from_pretrained("Gorilla115/t5-shakespearify-lite")

def Generate(text):
    enc= tokenizer.encode("translate: "+text,return_tensors="pt")
    out = model.generate(enc)
    return tokenizer.decode(out[0]).replace("<pad>","").replace("</s>","")

    # return "Hello " + name + "!!"

iface = gr.Interface(fn=Generate, inputs="text", outputs="text",examples=["Why have you come to Mr. Smith with this crap?","Who are you man?","You are in need of great care to fix this.","That’s true, and he asked me to beg both of you, your Majesties, to come and watch."], title="Shakespearify", description="""
This is a model trained on [shakescleare](https://www.litcharts.com/shakescleare/shakespeare-translations) a collection of Shakepeare's plays translated to modern english. This particular model was trained on almost 10k examples. There are a few caveats to the model as it is not always very effective. It stuggles with texts longer than 1 sentence also most of the time it may just do some minor word substitution. Uses the T5 general purpose model and trained for 4 epochs. See details [here](https://huggingface.co/Gorilla115/t5-shakespearify-lite).
""",article="[© Arnav G.](https://github.com/arnavg115)")
iface.launch()