import api_module as request
from zoom_video_composer import zoom_video_composer
import os


def process_prompt(api_key, prompt, task_id, path):
    # begin zoom out 2x process for upscaled task
    print(f'begin zoom out 2x from upscaled task: {task_id}/n')
    zoom_task_id = request.make_outpaint_request(api_key, prompt, task_id)
    #make sure the zoom_out task sucessfully
    if zoom_task_id is not None:
        pass
    elif zoom_task_id is None:
        print('Zoom out process failed, exiting...')
        raise SystemExit('Zoom out process failed')

    # make sure the zoom_out process has finished
    while True:
        status = request.fetch_request(api_key, zoom_task_id)[1]
        if status == 'finished':
            break
        elif status == 'failed':
            print('Zoom out process failed, exiting...')
            raise SystemExit('Zoom out process failed')

    # begin upscale one image from zoom_out task randomly
    print(f'begin upscale image from zoom_out task: {zoom_task_id}\n')
    upscale_task_id = request.make_upscale_request(api_key, zoom_task_id)
    # make sure the upscale task sucessfully
    if upscale_task_id is not None:
        pass
    elif upscale_task_id is None:
        print('Upscale process failed, exiting...')
        raise SystemExit('Upscale process failed')

    # make sure the upscale process has finished
    while True:
        upscale_image_url = request.fetch_request(api_key, upscale_task_id)[0]
        if upscale_image_url is not None:
            break
        elif upscale_image_url is None:
            print('Upscale process failed, exiting...')
            raise SystemExit('Upscale process failed')
    #download image and save it form url link
    request.download_image(upscale_image_url, path)

    return upscale_task_id
# main process function for goapi zoom_out video generation
def main_process(api_key, prompt1, prompt2=None, prompt3=None, prompt4=None):

    # check if prompt2, prompt3, prompt4 is None
    if prompt2 is None:
        prompt2 = prompt1
    if prompt3 is None:
        prompt3 = prompt1
    if prompt4 is None:
        prompt4 = prompt1

    # /imagine fist prompt 
    imagine_task_id = request.make_imagine_request(api_key, prompt1)
    # make sure the /imagine task sucessfully
    if imagine_task_id is not None:
        pass
    elif imagine_task_id is None:
        print('Imagine process failed, exiting...')
        raise SystemExit('Imagine process failed')
    # make sure the /imagine task has finished
    while True:
        imagine_image_url = request.fetch_request(api_key, imagine_task_id)[0]
        if imagine_image_url is not None:
            break
        elif imagine_image_url is None:
            print('Imagine process failed, exiting...')
            raise SystemExit('Imagine process failed')

    # begin upscale process
    upscale_task_id = request.make_upscale_request(api_key, imagine_task_id)
    # make sure the /upscale task sucessfully
    if upscale_task_id is not None:
        pass
    elif upscale_task_id is None:
        print('Upscale process failed, exiting...')
        raise SystemExit('Upscale process failed')
    # make sure the /upscale task has finished
    while True:
        upscale_image_url = request.fetch_request(api_key, upscale_task_id)[0]
        if upscale_image_url is not None:
            break
        elif upscale_image_url is None:
            print('Upscale process failed, exiting...')
            raise SystemExit('Upscale process failed')
    
    # download upscaled image from url link
    image_dir_path = request.download_image(upscale_image_url)
    # process the rest of prompts
    for prompt in [prompt2, prompt3, prompt4]:
        upscale_task_id = process_prompt(api_key, prompt, upscale_task_id, image_dir_path)
    # generate zoom_out video
    zoom_video_composer(
        image_paths=[image_dir_path],
        output=f'{image_dir_path}.mp4',
        duration=20,
        direction='outin',
        easing='easeInOutSine'
    )

    video_path = f'{image_dir_path}.mp4'
    return video_path