import gradio as gr
import goapi

example_youtube = '''
|     |     |     |
|-----|-----|-----|
|<iframe width="350" height="250" src="https://www.youtube.com/embed/ngbsz7krG3M?si=gJW2Ql0NuAHpt3rV&amp;controls=0" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>|<iframe width="350" height="250" src="https://www.youtube.com/embed/-3qrFvtD5d4?si=-M0ifsDeZgEmHqND&amp;controls=0" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>|<iframe width="350" height="250" src="https://www.youtube.com/embed/V4k-QbRakvg?si=mPK-jgWPa646wsi9&amp;controls=0" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>|

'''
DESCRIPTION = """
#  Midjourney Zoom Video Generator (by [GoAPI](https://www.goapi.ai/?utm_source=hg&utm_medium=zmv&utm_campaign=hg_zmv&utm_id=0904))
The Midjourney Zoom Video Generator allows user to input multiple Midjourney prompts and receive a zoom-out/zoom-in video composed from [Midjourney's Zoom Out](https://docs.midjourney.com/docs/zoom-out) generated pictures.

This project uses GoAPI's [Midjourney API](https://www.goapi.ai/midjourney-api?utm_source=hg&utm_medium=zmv&utm_campaign=hg_zmv&utm_id=0904), and  zoom in/out video generation script from [ZoomVideoComposer](https://github.com/mwydmuch/ZoomVideoComposer). 
![example](https://i.ibb.co/0yg9pbM/output-2023-09-01-00-00-00-00-00-30-00-00-00-00-00-30.gif)

## Instructions
1. Get your API key from GoAPI's [Midjourney API](https://www.goapi.ai/pricing-and-payment?utm_source=hg&utm_medium=zmv&utm_campaign=hg_zmv&utm_id=0904]), for only 1 dollar! GoAPI offers 1 dollar (=200 credits) or 5 dollar (=3000 credits) options; each video generation task needs 88 credits. Check your spam folder for emails. 

3. Enter your API key and the desired prompts for the zoom out/zoom in video.
4. Click the 'Submit' button - approximately 7 minute of waittime, **please do not refresh your page otherwise your job will be lost!**
5. Upon completion, the generated video will appear in the bottom right; **please do not refresh your page before download otherwise your video will be lost!**
"""

demo = gr.Interface(
    fn=goapi.main_process,
    title = 'GoAPI Midjourney Zoom Video Generator',
    api_name = 'mj-v2-zoom-video',
    description=DESCRIPTION,
    article=example_youtube,
    inputs=[
        gr.Textbox(
            label="GoAPI Key",
            lines=1, 
            show_copy_button=True,
            placeholder="Enter your GoAPI key here",   
        ),
        gr.Textbox(
            label="Prompt for generating first scene",
            lines=1,
            show_copy_button=True,
            interactive=True,
            placeholder="e.g. Batman in his signature suit, standing atop a Gotham city building --s 750",
        ),
        gr.Textbox(
            label="Prompt for generating second scene",
            lines=1,
            show_copy_button=True,
            interactive=True,
            placeholder="e.g. View widens to show Gotham City at night, lights twinkling amidst buildings --s 750",
        ),
        gr.Textbox(
            label="Prompt for generating third scene",
            lines=1,
            show_copy_button=True,
            interactive=True,
            placeholder="e.g. Further out, the sprawling city with traffic below, neon signs glowing --s 750",
        ),
        gr.Textbox(
            label="Prompt for generating fourth scene",
            lines=1,
            show_copy_button=True,
            interactive=True,
            placeholder="e.g. Perspective extends to show nearby city blocks, the Gotham City skyline as backdrop --s 750",
        ),
    ],
    outputs=gr.Video(label="Processed Video"),
)

demo.queue(
    concurrency_count=6,
)
demo.launch()