from transformers import pipeline
import gradio as gr

pipe = pipeline("text-generation", model="bigscience/T0", tokenizer="bigscience/T0")

def predict(text):
    return pipe(text)

title = "T0"
description = "Natural Language Processing is evolving. T0 language model was trained in multiple NLP tasks like summarization, paraphrase identification, question answering, natural language inference, sentiment classification and so forth"
examples = [
    ["'Earth is the third planet from the Sun and the only astronomical object known to harbour and support life. 29.2% of Earth's surface is land consisting of continents and islands. The remaining 70.8% is covered with water, mostly by oceans, seas, gulfs, and other salt-water bodies, but also by lakes, rivers, and other freshwater, which together constitute the hydrosphere.' How would you rephrase that in a few words?"],["'i lost my password' 'i want to change my password' Pick one: these questions are duplicates or not duplicates."],["I know that the answer to 'What is the only planet that supports life in the solar system?' is in 'Earth is the third planet from the Sun and the only astronomical object known to harbour and support life. 29.2% of Earth's surface is land consisting of continents and islands. The remaining 70.8% is covered with water, mostly by oceans, seas, gulfs, and other salt-water bodies, but also by lakes, rivers, and other freshwater, which together constitute the hydrosphere.'. Can you tell me what it is?"], ["Suppose 'i am the father of a beautiful boy named John'. Can we infer that 'I have a son'?"], ["One customer said: 'this product does not have the features shown on the website'. Is this review positive or negative?"], ["My birthday is the day after friday. When is my birthday?"], ["Write one sentence descriptions for product based on a list of features. Product: SmartTV. Features: - Good quality image - Internet access -  Perfect sound. One sentence description: The SmartTV has an excelent image quality, perfect sound and internet access. Product: SmartPhone. Features: - 5G access - Large screen - Large memory. One sentence description:"]
]
gr.Interface.load(fn=predict, inputs=gr.Textbox(lines=12, label="Input Text"),title=title,description=description, examples=examples).launch(share=True, debug=True)