import streamlit as st
import pandas as pd
import os
import plotly
import plotly.express as px

from functions.module_project_specific_functions import (
    f_streamlit_hide_menu_and_marks,
    f_streamlit_customize_page,
    f_100_prisoners_game_get_random_strategy_probability,
    f_100_prisoners_game_get_cf_strategy_probability,
    f_100_prisoners_game_simulate_cf_strategy, 
    f_100_prisoners_game_simulate_random_strategy
)

exec(open("./functions/module_project_specific_functions.py").read())


#%%% Page Configuration

# set_page_config() can only be called once per app, and must be called as
# the first Streamlit command in your script.
st.set_page_config(
    page_title = "100 Prisoners Game Riddle", 
    page_icon='www/100_prisoners_problem_favicon_1.jpg', # None ":memo:", ...
    layout='wide', # centered, wide
    initial_sidebar_state='auto' # auto, expanded, collapsed
)

# Hide Hamburger Menu and Streamlit logo 'Made with Streamlit'
f_streamlit_hide_menu_and_marks()

f_streamlit_customize_page(padding_top="0px", margin_top="0px")


#%% Plot Data

regenerate_data = False

if regenerate_data:
        
    even_numbers = [n for n in range(1, 150+1) if n%2==0]
    # round() to convert into integer. int() only works for strings
    even_numbers = [round(x) for x in even_numbers]

    random_prob = [] 
    cf_prob = []
    random_freq_prob = []    
    cf_freq_prob = []
    for n_prisoners in even_numbers:

        random_prob.append(
            f_100_prisoners_game_get_random_strategy_probability (    
                n_prisoners = n_prisoners
            )
        ) 
        
        cf_prob.append(
            f_100_prisoners_game_get_cf_strategy_probability(    
                n_prisoners = n_prisoners
            )
        ) 
            
        random_freq_prob.append(
            f_100_prisoners_game_simulate_random_strategy(    
                n_prisoners = n_prisoners, 
                n_games     = 100, 
                log_path    = None,
                display_level = None
            )
        )        
        
        cf_freq_prob.append(
            f_100_prisoners_game_simulate_cf_strategy(    
                n_prisoners = n_prisoners, 
                n_games     = 100, 
                log_path    = None,
                display_level = None
            )
        ) 

    #
    games_df = \
        pd.DataFrame(
            {'n_prisoners': even_numbers,
            'random_prob': random_prob,
            'random_freq_prob': random_freq_prob,
            'cf_prob': cf_prob,         
            'cf_freq_prob': cf_freq_prob,
            }
        )  

    #
    games_df.to_csv("data/games_df.csv",  index=False)
#    
games_df = pd.read_csv("data/games_df.csv")
# games_df.info()


#%% Plot

regenerate_plot = False

if regenerate_plot:
    
    # TODO: 'freq' refers to 'frequentist' but it would be better to replace with 'sim' from 'simulated'.
    prob_type_dict = {
        "random_prob":       "Random (Theoretical)",
        "random_freq_prob":  "Random (Simulated)",
        "cf_prob":           "Cycle-Following (Theoretical)",
        "cf_freq_prob":      "Cycle-Following (Simulated)"
    } 

    df_plot = \
        pd.melt(
            games_df, 
            id_vars="n_prisoners",
            value_vars=games_df.columns[1:],
            var_name="prob_type",
            value_name="prob"
        ) \
        .replace({"prob_type": prob_type_dict})
        
    fig = \
        px.line(
            df_plot, 
            markers=True,
            x = "n_prisoners", 
            y = "prob",
            color = "prob_type",
            labels={
                "prob":       "Probability (%)",
                "prob_type":    "", 
                "n_prisoners": "Number of Prisoners"          
            }   
        )
    #
    fig.update_layout(hovermode = "x unified")
    # fig.update_traces(hovertemplate = "%{y}")
    fig.update_traces(hovertemplate = "%{y:.2g}")

    #

    fig.update_layout(
        title_text = "", # plot_title,
        # Center Alignment
        title_x=0.5,
    )
    #
    fig.add_annotation(
        showarrow=False,
        text="*Simulated probabilities were generated from 100 random games played.",
        font=dict(size=14), 
        xref='paper',
        x=0,
        yref='paper',
        y=-0.25
    )
    #
    # fig.show(renderer="browser")

    fig.write_json('data/plot.json')
    
    
fig = plotly.io.read_json('data/plot.json')

plot_title = "Random vs. Cycle-Following (Optimal) Strategy <br>" + \
                "Theoretical and Simulated Probabilities*"
#                
st.markdown(f'''<h2 style='text-align: center;' > 
                 {plot_title}  </h2>''', unsafe_allow_html=True)

cols = st.columns([2,10,2])

with cols[1]:
    st.plotly_chart(fig)


#%% _______________________________________________


