
import streamlit as st
import os
import tempfile

from functions.streamlit_basic import get_binary_file_downloader_html

from functions.module_project_specific_functions import (
    f_streamlit_hide_menu_and_marks, 
    f_streamlit_customize_page,    
    f_100_prisoners_game_simulate_random_strategy,
    f_100_prisoners_game_simulate_cf_strategy
)

exec(open("./functions/module_project_specific_functions.py").read())  

if False:
    @st.experimental_memo
    def f_100_prisoners_game_simulate_cf_strategy_cached(**kwargs):
        
        success_rate =  \
            f_100_prisoners_game_simulate_cf_strategy(**kwargs)
    
        # return is necessary
        return success_rate
    

#%%% Page Configuration

# set_page_config() can only be called once per app, and must be called as
# the first Streamlit command in your script.
st.set_page_config(
    page_title = "100 Prisoners Game Riddle", 
    page_icon='www/100_prisoners_problem_favicon_1.jpg', # None ":memo:", ...
    layout='wide', # centered, wide
    initial_sidebar_state='auto' # auto, expanded, collapsed
)

# Hide Hamburger Menu and Streamlit logo 'Made with Streamlit'
f_streamlit_hide_menu_and_marks()

#
f_streamlit_customize_page(
    padding_top="10px", margin_top="10px"
)

#%% strategy

# NOTE: "delete=False" is necessary to make it work on Windows
# https://stackoverflow.com/questions/15169101/how-to-create-a-temporary-file-that-can-be-read-by-a-subprocess

# This makes sure to use the same temporary file 
# (in case of a cached function, this would prevent it to rerun)
if 'log_path1' not in st.session_state: 

    tempf = tempfile.NamedTemporaryFile(suffix=".txt", delete=False)
    st.session_state["log_path1"] = tempf.name
 
log_path1 =  st.session_state["log_path1"]    
# print(log_path1.replace("\\","/"))
# os.remove(log_path1)   
   
if 'log_path2' not in st.session_state:     
    tempf = tempfile.NamedTemporaryFile(suffix=".txt", delete=False)
    st.session_state["log_path2"] = tempf.name
    
log_path2 =  st.session_state["log_path2"]        
      
    
with st.form(key="cf_strategy_simulation"):

    st.markdown(f'''<h3 style='text-align: center; font-weight: bold;' > 
        GAMES SIMULATIONS <br>
       </h3>''', unsafe_allow_html=True)
        
    cols = st.columns(2)
    
    with cols[0]:
        n_prisoners = st.number_input("Number of Prisoners", value=4,
                                      min_value=2, max_value=180, step=2)

    with cols[1]:    
        n_games = st.number_input("Games Played (number of simulations)",
                                  value=5, min_value=2, max_value=200, step=1)
    
    cols = st.columns(2)
    with cols[0]:
        submit = st.form_submit_button("Generate")    

    with cols[1]:
        st.markdown('''<p style='text-align: left; font-style: italic;
                                 font-size: 15px;' > 
                    Note: Each game draws random numbers for the boxes.</p>''', unsafe_allow_html=True)

# BUG: Workaround: https://github.com/streamlit/streamlit/issues/3832#issuecomment-1138994421
if submit:
  st.session_state["submitted"] = True

if 'submitted' in st.session_state:
        
    cf_success_rate = \
        f_100_prisoners_game_simulate_cf_strategy(
        # f_100_prisoners_game_simulate_cf_strategy_cached(    
            n_prisoners = n_prisoners, 
            n_games     = n_games, 
            log_path    = log_path1,
            display_level = ["ALL", "SHORT", None][0]
        )
        
    random_success_rate = \
        f_100_prisoners_game_simulate_random_strategy( 
            n_prisoners = n_prisoners, 
            n_games     = n_games, 
            log_path    = log_path2,
            display_level = ["ALL", "SHORT", None][0]
        )        
        
    cols = st.columns(2) 
     
    with cols[0]:     
        st.markdown('''<h4 style='text-align: center; font-weight: bold;' > 
                        Cycle-Following (Optimal) Strategy </h4>''', unsafe_allow_html=True)
        # Simulated, Empirical / Experimental Probability
        st.markdown(f'''<h5 style='text-align: center; font-weight: bold;
                                   padding-bottom: 0px;' > 
            Simulated Probability of Winning the Game (Success Rate) </h5> ''', unsafe_allow_html=True
        )
        #
        st.markdown(f'''<h3 style='text-align: center; font-weight: bold;
                                   padding-top: 2px;' > 
            % {cf_success_rate}  </h3>''', unsafe_allow_html=True)
        
        with open(log_path1, "r") as f:
            log_str1 = f.read()
        #
        # log_str
        # print(log_str)
        #
        log_print1 = log_str1.replace('\n', '<br>')
        # os.startfile(log_path)
        # st.write(log_print)
        
        # REVIEW: https://github.com/streamlit/streamlit/issues/4382
        # with open(log_path1, 'r') as f:
        #     st.download_button(
        #         "Download Games Simulations",
        #         data=f, 
        #         file_name="100_Prisoners_Game_-_Optimal_Strategy.txt", 
        #         mime='text/plain'
        #     )         
        html_link = get_binary_file_downloader_html(
            file_path = log_path1,
            file_name = "100_Prisoners_Game_-_Optimal_Strategy.txt",
            file_label = 'Download Games Simulations',
            button_bgcolor = "rgb(72, 47, 142)",
            button_bordercolor = "rgba(250, 250, 250, 0.2)" 
        )
        # Display Link            
        st.markdown(html_link, unsafe_allow_html=True)        
            
        if n_prisoners > 10 or n_games > 20:
            st.warning("Large Games will not be displayed here, " +
                       "download the file instead.")  
        else:          
            st.markdown(log_print1, unsafe_allow_html=True)
            
    with cols[1]:     
        
        st.markdown('''<h4 style='text-align: center; font-weight: bold;' > 
                        Random strategy </h4>''', unsafe_allow_html=True)
        #        
        st.markdown(f'''<h5 style='text-align: center; font-weight: bold;
                                   padding-bottom: 0px;' > 
            Simulated Probability of Winning the Game (Success Rate) </h5> ''', unsafe_allow_html=True
        )
        #
        st.markdown(f'''<h3 style='text-align: center; font-weight: bold;
                                   padding-top: 2px;' > 
            % {random_success_rate}  </h3>''', unsafe_allow_html=True)

        with open(log_path2, "r") as f:
            log_str2 = f.read()
        #
        # log_str
        # print(log_str)
        #
        log_print2 = log_str2.replace('\n', '<br>')
        # os.startfile(log_path)
        # st.write(log_print)

        # with open(log_path2, 'r') as f:
        #     st.download_button(
        #         "Download Games Simulations",
        #         data=f, 
        #         file_name="100_Prisoners_Game_-_Random_Strategy.txt", 
        #         mime='text/plain'
        #     ) 
        html_link = get_binary_file_downloader_html(
            file_path = log_path2,
            file_name = "100_Prisoners_Game_-_Random_Strategy.txt",
            file_label = 'Download Games Simulations',
            button_bgcolor = "rgb(72, 47, 142)",
            button_bordercolor = "rgba(250, 250, 250, 0.2)" 
        )
        # Display Download button            
        st.markdown(html_link, unsafe_allow_html=True)             
            
        if n_prisoners > 10 or n_games > 20:
            st.warning("Large Games will not be displayed here, " +
                    "download the file instead.")  
        else:          
            st.markdown(log_print2, unsafe_allow_html=True)            
        
        

#%% ___________________________________________


