import streamlit as st
import streamlit.components.v1 as components
import requests
import json

from functions.module_project_specific_functions import (
    f_streamlit_hide_menu_and_marks,
    f_streamlit_customize_page,
)

st.set_page_config(
    page_title = "100 Prisoners Game Riddle", 
    page_icon='www/100_prisoners_problem_favicon_1.jpg', # None, ":memo:", ...
    layout='wide', # centered, wide
    initial_sidebar_state='auto' # auto, expanded, collapsed
)

# Hide Hamburger Menu and Streamlit logo 'Made with Streamlit'
f_streamlit_hide_menu_and_marks()

#
f_streamlit_customize_page(padding_left="10px", margin_left="0px",
                           padding_top="10px", margin_top="10px")


# wiki_problem_url = "https://en.wikipedia.org/wiki/100_prisoners_problem#Problem"
# components.iframe(wiki_problem_url, height=500, width= 550, scrolling=True)

cols = st.columns([5,2,5])

with cols[0]:

    wiki_problem_url = "https://en.wikipedia.org/wiki/100_prisoners_problem#Problem"
    components.iframe(wiki_problem_url, height=500, width= 550, scrolling=True)

with cols[2]:
                                         
    wiki_solution_url = "https://en.wikipedia.org/wiki/100_prisoners_problem#Solution"
    components.iframe(wiki_solution_url, height=500, width= 450, scrolling=True)

