#%%% get_binary_file_downloader_html()

def get_binary_file_downloader_html(
    file_path, 
    file_name = None,
    file_label = 'Click to Download File',
    button_bgcolor = ["inherit", "rgb(72, 47, 142)"][0],
    button_bordercolor = ["inherit", "rgba(250, 250, 250, 0.2)"][0]
):
    """
    Create html component to generate a download link for any file, so that the user can download just by clicking at it.
    Args:
        file_path (str): [file path]
        file_label (str): [label to display]. Defaults to 'File'.
    Returns:
        [str]: [html element]    
    Details: See the discussions 
        - <https://discuss.streamlit.io/t/how-to-download-file-in-streamlit/1806>   
        - <https://github.com/streamlit/streamlit/issues/4382>
    """     
    import os
    import base64
    #
    if file_name is None:
        file_download_name = os.path.basename(file_path)
    else:
        file_download_name = file_name
    #
    with open(file_path, 'rb') as f:
        data = f.read()
    #
    bin_str = base64.b64encode(data).decode()
    #
    href = f'''
        <a href="data:application/octet-stream;base64,{bin_str}" download="{file_download_name}" style="
                display: inline-flex;
                -webkit-box-align: center;
                align-items: center;
                -webkit-box-pack: center;
                justify-content: center;
                font-weight: 400;
                padding: 0.25rem 0.75rem;
                border-radius: 0.25rem;
                margin: 0px;
                line-height: 1.6;
                color: inherit;
                width: auto;
                user-select: none;
                text-decoration: none;
                background-color: {button_bgcolor};
                border: 1px solid {button_bordercolor};
                cursor: pointer;
            " > {file_label} </a>
    '''
    return href

# Test
if False:    
    # Save dataframe as a .xlsx file
    file_name = "dataframe.xlsx"
    df_download = pd.read_csv('https://raw.githubusercontent.com/mwaskom/seaborn-data/master/iris.csv')
    df_download.to_excel(file_name)   
    # HTML Link element
    html_link = get_binary_file_downloader_html(
        file_path = file_name,
        file_label = 'Clique para efetuar o download da tabela em .xlsx'
    )
    # Display Link 
    import streamlit as st           
    st.markdown(html_link, unsafe_allow_html=True)