import numpy as np



#%%% f_streamlit_hide_menu_and_marks
def f_streamlit_hide_menu_and_marks():
    '''
    # Hide Hamburger Menu and Streamlit logo 'Made with Streamlit'
    '''
    import streamlit as st
    
    hide_menu_footer = """
        <style>
            #MainMenu {visibility: hidden;}
            footer {visibility: hidden;}        
        </style>
    """
    st.markdown(hide_menu_footer, unsafe_allow_html=True)  
    

#%%% f_streamlit_customize_page
def f_streamlit_customize_page(
    margin_top = "",    
    padding_top = "",
    margin_left = "",
    padding_left = ""
):

    import streamlit as st
    
    st_style = f"""
        <style>
            .appview-container .main .block-container{{
                margin-top: {margin_top}; 
                padding-top: {padding_top};  
                margin-left: {margin_left};  
                padding-left: {padding_left};  
            }}           
        </style>
    """
    st.markdown(st_style, unsafe_allow_html=True)     
    

#%% f_100_prisoners_game_get_random_strategy_probability
def f_100_prisoners_game_get_random_strategy_probability(
    n_prisoners = 6
):
    
    "Get the Probability of the Random Strategy for the 100 Prisoners Problem."
        
    # Converges to 0 (zero)
    theoretical_probability = (1/2)**n_prisoners
    
    return 100*theoretical_probability
#
#
# Tests
if False:
    f_100_prisoners_game_get_random_strategy_probability(2)
    f_100_prisoners_game_get_random_strategy_probability(4)
    f_100_prisoners_game_get_random_strategy_probability(6)
    f_100_prisoners_game_get_random_strategy_probability(100)
    f_100_prisoners_game_get_random_strategy_probability(10000)



#%% f_100_prisoners_game_get_cf_strategy_probability
def f_100_prisoners_game_get_cf_strategy_probability(
    n_prisoners = 6
):
    
    "Get the Probability of the Cycle-Following (Optimal) Strategy for the 100 Prisoners Problem."
    
    import numpy as np
    
    def f_HN(n):
        "Generate n-th Harmonic Number."
        return np.sum(1/np.arange(1,n+1))

    # Converges to 0.30685
    theoretical_probability = 1 - (f_HN(n_prisoners) - f_HN(n_prisoners/2))
    
    return 100*theoretical_probability
#
#
# Tests
if False:
    f_100_prisoners_game_get_cf_strategy_probability(2)
    f_100_prisoners_game_get_cf_strategy_probability(4)
    f_100_prisoners_game_get_cf_strategy_probability(6)
    f_100_prisoners_game_get_cf_strategy_probability(100)
    f_100_prisoners_game_get_cf_strategy_probability(10000)





#%% f_100_prisoners_game_simulate_random_strategy
def f_100_prisoners_game_simulate_random_strategy(
    n_prisoners = 6, 
    n_games = 5, # number of samples (games played)
    display_level = [None, "SHORT", "ALL"][0],
    log_path = None
):
  
    "Random Strategy for the 100 Prisoners Problem."

    # 100 prisoners Game problem:
    # https://en.wikipedia.org/wiki/100_prisoners_problem
    
    import numpy as np
    from loguru import logger
    import sys
    import os
    
    if display_level is None:
        level = "CRITICAL"
    if display_level=="SHORT":
        level = "INFO",
    if display_level=="ALL" : 
        level = "TRACE" 
    
    logger.remove()
    
    if (log_path != None):
        
        try:
            os.remove(log_path)
        except Exception:
            pass    
        
        logger.add(log_path, format="{message}", level=level)
        # logger.debug(f"Log Path: {log_path}")
     
    else:
        logger.add(sys.stderr, format="{message}", level=level)    

    n_prisoners = n_prisoners
    prisoners_numbers = [*range(n_prisoners)] # starts at 0
    n_games = n_games 
    max_box_open = round(n_prisoners/2) # round to make it integer

    logger.debug("-------------------------------------------------------")
    logger.debug("100 PRISONERS PROBLEM - GAMES SIMULATION")    
    logger.debug(f"Random Strategy")        
    logger.debug(f"Prisoners: {n_prisoners}")
    logger.debug(f"Games Played (number of simulations): {n_games}")

    n_game_success = 0
    for game in range(1, n_games+1):
        
        logger.debug("-------------------------------------------------------")
        logger.debug(f"Game: {game}")

        # If you want to get reproducible results
        # np.random.seed(game)
        boxes_numbers = np.random.choice(prisoners_numbers, size=n_prisoners,
                                         replace=False)
        boxes_dict = {k: v for k, v in enumerate(boxes_numbers)}
        logger.debug(f"{{Box Number: Prisoner Number}} -> {boxes_dict}")
        
        n_prisoner_success = 0
        for prisoner_num in prisoners_numbers:
            
            logger.debug("--")
            logger.debug(f"Prisoner Number: {prisoner_num}")
            
            prisoner_choice_sequence = \
                np.random.choice(boxes_numbers, size=max_box_open, 
                                 replace=False)
                
            logger.debug(f"Prisoner Box Choice Sequence: " + \
                         f"{prisoner_choice_sequence}")
            
            box_revealed_sequence = boxes_numbers[prisoner_choice_sequence]
            
            logger.debug(f"Prisoner Revealed Number Sequence: " + \
                         f"{box_revealed_sequence}") 
            
            success = prisoner_num in box_revealed_sequence
            logger.debug(f"Success: {success}")
            
            if success:
                n_prisoner_success = n_prisoner_success + 1

        logger.debug("--")            
        logger.debug("Prisoners' Success: " + \
                    f"{n_prisoner_success}/{n_prisoners}")
        #
        if n_prisoner_success == n_prisoners:
            n_game_success = n_game_success + 1

    logger.debug("\n---------------------------------------------------------")
    logger.info(f"Prisoners: {n_prisoners}")
    logger.info(f"Games Played: {n_games}")
    logger.info(f"Successful Games = {n_game_success}") 
    success_rate = round(100*n_game_success/n_games, 1)
    logger.info(
        "Simulated Probability of Winning the Game (Success Rate) = " + \
        f"% {success_rate}"
    )  
    logger.debug("---------------------------------------------------------")
    
    return success_rate
#
#
# Test
if False:
    #
    f_100_prisoners_game_simulate_random_strategy(
        n_prisoners = 4, 
        n_games     = 5, 
        log_path    = None,
        display_level = ["ALL", "SHORT", None][0]
    )
    #
    f_100_prisoners_game_simulate_random_strategy(
        n_prisoners = 6, 
        n_games     = 100, 
        log_path    = None,
        display_level = None
    )




#%% f_100_prisoners_game_simulate_cf_strategy
def f_100_prisoners_game_simulate_cf_strategy(
    n_prisoners = 6, 
    n_games = 5, # number of samples (games played)
    display_level = [None, "SHORT", "ALL"][0],
    log_path = None
):
   
    "Cycle-Following (Optimal) Strategy for the 100 Prisoners Problem."
    
    # 100 prisoners Game problem:
    # https://en.wikipedia.org/wiki/100_prisoners_problem
    
    import numpy as np
    from loguru import logger
    import sys
    import os
    
    if display_level is None:
        level = "CRITICAL"
    if display_level=="SHORT":
        level = "INFO",
    if display_level=="ALL" : 
        level = "TRACE" 
    
    logger.remove()
    
    if (log_path != None):
        
        try:
            os.remove(log_path)
        except Exception:
            pass    
        
        logger.add(log_path, format="{message}", level=level)
        # logger.debug(f"Log Path: {log_path}")
     
    else:
        logger.add(sys.stderr, format="{message}", level=level)    

    n_prisoners = n_prisoners
    prisoners_numbers = [*range(n_prisoners)] # starts at 0
    n_games = n_games 
    n_game_success = 0
    max_box_open = n_prisoners/2

    logger.debug("-------------------------------------------------------")
    logger.debug("100 PRISONERS PROBLEM - GAMES SIMULATION")
    logger.debug("Cycle-Following (Optimal) Strategy")      
    logger.debug(f"Prisoners: {n_prisoners}")
    logger.debug(f"Games Played (number of simulations): {n_games}")

    for game in range(1, n_games+1):
        
        logger.debug("-------------------------------------------------------")
        logger.debug(f"Game: {game}")

        # If you want to get reproducible results
        # np.random.seed(game)
        boxes_numbers = np.random.choice(prisoners_numbers, size=n_prisoners,
                                         replace=False)
        boxes_dict = {k: v for k, v in enumerate(boxes_numbers)}
        logger.debug(f"{{Box Number: Prisoner Number}} -> {boxes_dict}")
        
        n_prisoner_success = 0
        for prisoner_num in prisoners_numbers:
            logger.debug("--")
            logger.debug(f"Prisoner Number: {prisoner_num}")
            box_chosen_num = prisoner_num
            n_box_open = 1
            while n_box_open <= max_box_open:
                n_box_open = n_box_open + 1
                box_revealed_num = boxes_numbers[box_chosen_num]
                logger.debug(f"Box Chosen Number: {box_chosen_num}")
                logger.debug(f"Box Revealed Number: {box_revealed_num}")
                success = box_revealed_num == prisoner_num
                if success:
                    n_prisoner_success = n_prisoner_success + 1
                    logger.debug(f"Success: {success}")
                    break
                else:
                    box_chosen_num = box_revealed_num
                    continue
            else:
                logger.debug(f"Success: {success}")        
        logger.debug("--")            
        logger.debug("Prisoners' Success: " + \
                    f"{n_prisoner_success}/{n_prisoners}")
        #
        if n_prisoner_success == n_prisoners:
            n_game_success = n_game_success + 1

    logger.debug("\n---------------------------------------------------------")
    logger.info(f"Prisoners: {n_prisoners}")
    logger.info(f"Games Played: {n_games}")
    logger.info(f"Successful Games = {n_game_success}") 
    success_rate = round(100*n_game_success/n_games, 1)
    logger.info(
        "Simulated Probability of Winning the Game (Success Rate) = " + \
        f"% {success_rate}"
    )  
    logger.debug("---------------------------------------------------------")
    
    return success_rate
#
#
# Test
if False:
    f_100_prisoners_game_simulate_cf_strategy(
        n_prisoners = 6, 
        n_games     = 5, 
        log_path    = None,
        display_level = "ALL"
    )


    
    
#%% _______________________________________________________

         