

#%% APP ROOT PAGE 


#%%% Packages Installation

if False:
    '''
    # - # CONDA ENV
    # Use mamba in the case of creating a new conda env using an environment.yaml file
    conda install mamba -n base -c conda-forge
    mamba env create -f environment.yml
    '''


#%%% Modules Importation

import streamlit as st
import pandas as pd
import numpy as np
#
import datetime, re # deal with date/time and regex
import plotly
#
import base64
import PIL
import requests
import os
import dotenv

from functions.module_project_specific_functions import (
    f_streamlit_hide_menu_and_marks,
    f_streamlit_customize_page,
)

#%%% App Configuration

#%%%% Page Configuration

# set_page_config() can only be called once per app, and must be called as
# the first Streamlit command in your script.
st.set_page_config(
    page_title = "100 Prisoners Game Riddle", 
    page_icon='www/100_prisoners_problem_favicon_1.jpg', # None ":memo:", ...
    layout='wide', # centered, wide
    initial_sidebar_state='auto' # auto, expanded, collapsed
)

#%%%% Set Environment Mode ('test' or 'production') and Load Configurations

# load environment variables
dotenv.load_dotenv(".env", override=True, verbose=True)
#
os.getenv("ENV_MODE")
os.getenv("APP_NAME")
os.getenv("APP_FOLDER_NAME")
print(st.session_state)
#
if "config_mode" not in st.session_state:    
    st.session_state['config_mode'] = os.getenv("ENV_MODE")
    

#%%%% Remove Hamburger Menu and Streamlit logo
   
if st.session_state['config_mode']=='production':
    
    f_streamlit_hide_menu_and_marks()
    f_streamlit_customize_page(padding_top="0px", margin_top="0px")


#%%% Sidebar Layout

title = "100 PRISONERS PROBLEM"
# st.title(title)
st.markdown(f"<h1 style='text-align: center;'>{title}</h1>", 
            unsafe_allow_html=True)

subtitle = "The Most Intriguing Riddle in Probability Theory"
st.markdown(f'''<h2 style='text-align: center; font-style: italic;' > 
                 {subtitle}  </h2>''', unsafe_allow_html=True)

cols = st.columns([2,2])

with cols[0]:
    st.image(
        PIL.Image.open("www/100_prisoners_problem_1.png"), 
        use_column_width=False, width=410
    )

with cols[1]:
    st.video("https://youtu.be/iSNsgj1OCLA")


#%% _________________________________________________________


