

#%% ________________________________________________________

#%% ENVIRONMENT PREPARATION PART

#%%% Load modules

import dotenv
import os
import re
import pandas as pd
import pdb
from sspipe import px as _, p


#%%% Set Environment Variables in Terminal 

# TODO: Copy and paste printed results to the WSL Ubuntu Linux terminal

# dotenv.load_dotenv(".env", override=True, verbose=True)
dotenv.load_dotenv(".env.shared", override=True, verbose=True) 
os.environ
# Set new environment variables
os.environ["APP_DIR"] = os.getcwd()
os.getenv("APP_DIR")

with open("version.txt", mode="r") as file:
    APP_VERSION = file.read().strip()

def f_path_wsl(path):
    '''Convert Windows path into a mounted WSL path'''
    wsl_path = re.sub("D:|d:","/mnt/d", path.replace(os.sep, "/"))
    wsl_path = re.sub("C:|c:","/mnt/c", wsl_path)
    return wsl_path

APP_DIR = os.getcwd() | p(f_path_wsl)
APP_NAME = os.environ["APP_NAME"]
APP_FOLDER_NAME = os.environ["APP_FOLDER_NAME"]
APP_DOCKER_IMAGE= APP_FOLDER_NAME
APP_DOCKERHUB_IMAGE = f"hagenfin/projects:{APP_DOCKER_IMAGE}"
# APP_DOCKERHUB_IMAGE = f"{APP_DOCKERHUB_IMAGE}_v{APP_VERSION}"
APP_DOCKER_CONT = f"{APP_DOCKER_IMAGE}_cont"
APP_DC_PROJECT = f"{APP_FOLDER_NAME}_dc_project"

f'''
    cd {APP_DIR}
    export APP_DIR={APP_DIR}
    export APP_NAME="{APP_NAME}"
    export APP_VERSION="{APP_VERSION}"
    export APP_FOLDER_NAME={APP_FOLDER_NAME} 
    export APP_DOCKER_IMAGE={APP_DOCKER_IMAGE} 
    export APP_DOCKERHUB_IMAGE={APP_DOCKERHUB_IMAGE}
    export APP_DOCKER_CONT={APP_DOCKER_CONT}
    export APP_DC_PROJECT={APP_DC_PROJECT}
''' | p(print)


#%%% environment_manual.yaml
%%writefile environment_manual.yml
#
name: 100_prisoners_problem_streamlit_app
channels:
  - defaults
  - conda-forge
  # - pytorch
  # - plotly
dependencies:
  - python=3.10
  - pip>=22.2.2
  - pandas>=1.5.0
  - pip:
    - streamlit==1.15.1
    - plotly==5.10.0
    # - dill>=0.3.5.1
    # - markdown>=3.4.1
    - loguru>=0.6.0
    #
    - ipykernel>=6.15.3
    - nbformat>=5.6.0
    #
    - sspipe>=0.1.17  
    - python-dotenv==0.21.0
    - confuse==2.0.0    
# prefix: C:\Users\flavio\miniconda3\envs\100_prisoners_problem_streamlit_app


#%%% Check Bash OS (should be WSL Ubuntu Linux)
%%script bash
# TODO: VScode fails here, you should run directly on the terminal
env
ls
# cd . && tree
tree . -L 2 
pwd
lsb_release -a
which bash
echo "$BASH_VERSION"


#%%% Create Conda Environment
%%bash
# TODO: it's better to run directly on the terminal instead of VScode
# The name of the conda env is already on the .yml file
conda env create -f environment_manual.yml


#%%% environment.yaml
%%script bash
# NOTE: VScode fails here, you should run directly on the terminal
conda activate ${APP_FOLDER_NAME}
conda env export > environment.yml



#%% ________________________________________________________________



#%% DEPLOYMENT PART



#%%% .dockerignore
%%writefile .dockerignore

.git
.Rproj.user/
.Rhistory
.RData
.RDataTmp
.Ruserdata

.vscode/
**/__pycache__

.darts/

.Rprofile
.Renviron
.env
.env.secrets
config_secrets.yml
config_secrets.yaml

/output/
  
/temp/

/tests/

/log/
  
/data/temp/
/data_backup/
/data_raw/

manifest.json


#%%% Dockerfile
%%writefile Dockerfile

FROM continuumio/miniconda3:4.12.0
# 2022/06/13 - debian amd64

# - # 
ARG workdir=/app
WORKDIR ${workdir}
# Detect if inside Docker
ENV IN_DOCKER_CONTAINER=True
#
ARG myenv=100_prisoners_problem_streamlit_app
# python major.minor.micro versions
# ARG py_version="3.8.10"
ARG py_version_minor="3.10"
ARG pkg_dir="/opt/conda/envs/${myenv}/lib/python${py_version_minor}/site-packages" 

# - # Install Linux System Dependencies
# RUN apt-get update \
#     && apt-get -y install xvfb libfontconfig wkhtmltopdf

# - # Create environment with specified Python version and Pip
# RUN conda create --name=${myenv} python=${py_version} pip

# - # Create environment from conda environment.yml file
# File generated by: "conda env export > environment.yml"
# platform-free file:  "conda env export > environment.yml --no-builds" 
# platform-free file / only the specified by the user:
#   "conda env export > environment.yml --from-history" 
# https://stackoverflow.com/a/39299669/13684783
# NOTE: Recommendation: manually create an environment.yml file and specify
# or pin only the dependencies that you care about, since a .yml file create
# in one system most likely will not work in other.
# NOTE: Importance in setting strict priority to increase speed
# https://docs.conda.io/projects/conda/en/latest/user-guide/tasks/manage-channels.html#strict-channel-priority
# Ways to set priority:
# https://stackoverflow.com/a/50671425
ARG env_yml="environment_manual.yml"
COPY ${env_yml} ${workdir} 
# NOTE: set priority in an .yml file using this trick:
# https://stackoverflow.com/a/65983247/13684783
RUN conda install mamba --name=base -c conda-forge \
    && mamba env create --name=${myenv} --file=${env_yml} \
    # Shrink Docker Image Size:
    # https://jcristharif.com/conda-docker-tips.html
    && conda clean --yes --all -f \
    && find /opt/conda/ -follow -type f -name '*.a' -delete \
    && find /opt/conda/ -follow -type f -name '*.pyc' -delete \
    && find /opt/conda/ -follow -type f -name '*.js.map' -delete 

# - # Create environment from pip requirements.txt
# File generated by: "pip freeze > requirements.txt"
# RUN pip install --no-cache-dir -r requirements.txt 

# REVIEW: It is very hard to enable using 'conda activate' and other conda
# commands inside docker. I tried most things but they didn't work. Therefore,
# my work around was to specify the environment and path to install the
# packages.
# Another workaround is to use just the 'base' conda environment.
# https://github.com/conda/conda/issues/7980#issuecomment-441358406
# https://stackoverflow.com/a/62737129/13684783
# Add miniconda to system path
ENV PATH /opt/conda/envs/${myenv}/bin:$PATH

# - # Install packages manually via Conda
# RUN conda install --yes --freeze-installed \
#     --name=${myenv} --channel=conda-forge \
#    # this reduces size: use openblas instead of mkl (unavailable on Windows)
#    # nomkl \ 
#    numpy==1.21.1 

# - # Install packages manually via Pip
# RUN pip install --target=${pkg_dir} --no-cache-dir --no-input \
#     numpy==1.21.2 --upgrade

# - # Copy all files from current directory to docker /app
COPY . ${workdir}

# - # This will activate the environment (> overwrites, >> appends)
# NOTE: However, just when the container is created, not right now.
# NOTE: 'conda activate' does not work, you have to use 'source activate'
RUN echo "source activate ${myenv}" > ~/.bashrc
# RUN echo "source activate base" > ~/.bashrc

# - # Copy all files from current directory to docker /app
# COPY . ${workdir}
COPY version.txt version.txt

# - # streamlit-specific commands for config
ENV LC_ALL=C.UTF-8
ENV LANG=C.UTF-8
#
RUN mkdir -p /root/.streamlit
#
RUN bash -c 'echo -e "\
[general]\n\
email = \"\"\n\
" > /root/.streamlit/credentials.toml'
#
RUN bash -c 'echo -e "\
[server]\n\
enableCORS = false\n\
" > /root/.streamlit/config.toml'
#
EXPOSE 8501

# - # Switch shell sh to bash (default in Linux)
# SHELL ["/bin/bash", "-c"]

# - # Set a command to run when the container is started
# NOTE: This might be handy, however if I set CMD, I could not find a
# way to run the container interactively (-i -t)
# CMD ["streamlit","run","app.py"]

# - # References
# + https://docs.anaconda.com/anaconda/user-guide/tasks/docker/
# + https://hub.docker.com/r/continuumio/miniconda3



#%%% ____

# TODO: Run all 'Bash' commands directly in the WSL Ubuntu Linux

#%%% Build Image
%%bash
docker build . --tag ${APP_DOCKER_IMAGE} --file Dockerfile

#%%% Build Image using Existing Image as Cache (optional)
%%bash
docker build . --cache-from=${APP_DOCKER_IMAGE} --tag new_image --file Dockerfile

#%%% Access Container Interactively 
%%bash
docker run --rm --name ${APP_DOCKER_CONT} -it ${APP_DOCKER_IMAGE}
# NOTE: -> Press CTRL+D (or type 'exit') to exit container interactive session

#%%% Run Internal App file (when it exists)
%%bash 
docker run --rm --name ${APP_DOCKER_CONT} -p 8052:8050 -i -t ${APP_DOCKER_IMAGE} streamlit run Home.py 
# or ?
docker run --rm --name ${APP_DOCKER_CONT} -p 8052:8050 ${APP_DOCKER_IMAGE} bash -c "streamlit run Home.py"

#%%% Run Container Connecting to Host files
%%bash
# NOTE: docker does not understand relative paths, only absolute paths.
# NOTE: Running throung Windows is not working, we need to run via WSL Ubuntu, remembering to use the WSL path format (/mnt/d/...).
docker run --rm --name ${APP_DOCKER_CONT} -p 8052:8050 -v $(pwd)/:/app/ -i -t ${APP_DOCKER_IMAGE} streamlit run Home.py


#%%% Open App URL
import webbrowser
# webbrowser.open('http://localhost:8050/{APP_NAME}', new=0, autoraise=True)
webbrowser.open('http://localhost:8052/', new=0, autoraise=True)
# Production ('prod') with NGINX
webbrowser.open(f'http://localhost:8052/{APP_NAME}', new=0, autoraise=True)


#%%% Retag image and push to Dockerhub
%%bash
docker tag ${APP_DOCKER_IMAGE}  ${APP_DOCKERHUB_IMAGE} 
docker push ${APP_DOCKERHUB_IMAGE} 


#%%% ____


#%%% nginx.conf
%%writefile nginx.conf

events { }

http {
  map $http_upgrade $connection_upgrade {
  default upgrade;
  ''
  close;
  }
  
  server {
    listen 80;
    # <your_subdomain.com>;
    # server_name  hagenfin.com; 
    server_name  apps.hagenfin.com;
    # 302: temporary redirect; 301: permanent redirect
    # https://<your_subdomain.com>$request_uri;
    return 301 https://apps.hagenfin.com$request_uri; 
    # return 301 https://hagenfin.com$request_uri; 
  }
  
  server {
    listen       443 ssl;
    server_name  hagenfin.com;
    
    ssl_certificate ssl/ssl_hagenfin.pem;
    ssl_certificate_key ssl/ssl_hagenfin.key;

    access_log /var/log/nginx/data-access.log combined;
    
    # Code to redirect Dash service / container 1
    # location / {
    #   rewrite ^/(.*)$ /$1 break;
    # NOTE: The location must be the same as Dash 'requests_pathname_prefix':   
    location /100-prisoners-problem/ {
     rewrite ^/100-prisoners-problem/(.*)$ /$1 break;
        proxy_pass http://streamlit-service:8501;
        # proxy_pass http://127.0.0.1:8501;
        proxy_redirect http://streamlit-service:8501/ $scheme://$host;
        #
        proxy_http_version 1.1; 
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header Host $host;
        # streamlit specific: 
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection "upgrade";
        proxy_read_timeout 86400;
    }
  }
  
}

# End document with a blank line 


#%%% docker-compose.yml
%%writefile docker-compose.yml

version: '3'
services:
  nginx-service:
    image: nginx:latest
    container_name: nginx_cont
    restart: unless-stopped
    ports:
      - 80:80
      - 443:443
    volumes:
      # NOTE: ${HOME}/ and ~/ do not work with docker-compose!
      # https://github.com/docker/docker.github.io/pull/8538
      # - /home/user_name/... -> /home/ubuntu/
      - ./nginx.conf:/etc/nginx/nginx.conf
      # BUG: you might have to remove the final '/' for it to work.
      - /home/ubuntu/ssl/:/etc/nginx/ssl/  
      #- /home/ubuntu/ssl_hagenfin.pem:/etc/nginx/ssl/ssl_hagenfin.pem
      #- /home/ubuntu/ssl_hagenfin.key:/etc/nginx/ssl/ssl_hagenfin.key      
  streamlit-service:
    image: hagenfin/projects:100_prisoners_problem_streamlit_app
    container_name: streamlit_cont # change name if it conflicts
    restart: unless-stopped
    ports:
      - 8501 # Not linked to another port, only nginx will have access
    volumes:
      - ./:/app/
    command: streamlit run Home.py


#%%% Run docker-compose.yml as a project and show logs
%%bash
#
docker-compose --file docker-compose.yml --project-name ${APP_DC_PROJECT} up --remove-orphans -d && docker-compose -p ${APP_DC_PROJECT} logs -f
# or temporary (recommended for tests)
docker-compose --file docker-compose.yml --project-name ${APP_DC_PROJECT} up --remove-orphans


#%%% Open App URL
import webbrowser
# Production ('prod') with NGINX
webbrowser.open(f'https://apps.hagenfin.com/{APP_NAME}', new=0, autoraise=True)


#%%% Restart docker-compose project
%%bash
docker-compose --project-name ${APP_DC_PROJECT} restart && docker-compose -p ${APP_DC_PROJECT} logs -f


#%%% Show Docker Compose Projects
%%bash
# show all running dc projects
docker compose ls
# list all stopped dc projects
docker compose ls --all


#%%% Stop and Remove Apps Containers
%%bash
docker-compose -p ${APP_DC_PROJECT} down
docker-compose --project-name ${APP_DC_PROJECT} down 
# or
docker-compose --file docker-compose.yml down
#

#%%% Docker Management with `lazydocker`
%%bash
sudo lazydocker



#%% ________________________________________________


