import yfinance as yf
import pandas as pd
import streamlit as st
import numpy as np
import plotly.graph_objs as go
import plotly.offline as pyo
import pandas_ta as ta

st.header("Enter Market/Stock Ticker")
symbol = st.text_input('Enter Symbol', "ADANIENT.NS")
period = st.text_input('Enter Time Period', "60d")
"""(use *"60d"* for min intervals and date(MM-DD-YYY) for other intervals)"""
interval = st.text_input('Enter Time Interval', "30m") 

def get_data():
    df = yf.download(symbol, period=period, interval=interval)
    #'2021-03-01', '2023-03-01'
    #df = yf.download(symbol, period, interval)
    df = df.drop(columns=['Volume', 'Adj Close'], axis=1)
    df.reset_index(inplace=True)

    return(df)

data = get_data()


def movingAvgs(mov1: int, mov2: int):
    data["sma100"] = ta.ema(data["Close"], length=mov1)
    data["sma21"] = ta.ema(data["Close"], length=mov2)
    for i in range(len(data)):
        # ! BULLISH
        data.loc[data['sma21'] >= data["sma100"], 'movAvgSignal'] = 1
        # ! BEARISH
        data.loc[data['sma21'] <= data["sma100"], 'movAvgSignal'] = -1


def iMACD():
    data['ema5'] = data['Close'].rolling(window=5).mean()
    data['ema13'] = data['Close'].rolling(window=13).mean()
    data['i_macd'] = data['ema5'] - data['ema13']

    return data


def plot_iMACD():
    dfpl = data[5500:]
    fig = go.Figure()
    fig.add_trace(go.Scatter(x=data.index, y=data.ema5,
                         mode='lines', line_color='red', name='5-day EMA'))
    fig.add_trace(go.Scatter(x=data.index, y=data.ema13,
                         mode='lines', line_color='green', name='13-day EMA'))
    fig.update_layout(title='IMPulse MACD Chart',
                      xaxis_title='Date',
                      yaxis_title='IMPulse MACD')
    fig.show()

    return data


def ene_iMACD( diff: int ):
    data['ptc_change'] = (data['ema13'] - data['ema5']).pct_change(periods=1)
    data['short_long'] = 0
    # SHORT == -1
    # LONG  ==  1
    # Default ptc_change difference == 0.037
    data.loc[data['ptc_change'] >= diff, 'short_long'] = 1
    data.loc[(data['ptc_change'] <= diff) & (data['ptc_change'] >= -diff), 'short_long'] = -1
    data.loc[data['ptc_change'] <= -diff, 'short_long'] = 1
    #counts = data['short_long'].value_counts()
    #print(counts)

    return data


def ene_SMI( n: int ): # n = number of lookback days (default = 20)
    # BOLLINGER BANDS
    std_20d = data['Close'].rolling(n).std()
    data['m_bband'] = data['Close'].rolling(n).mean()
    data['u_bband'] = data['m_bband'] + std_20d * 1.5
    data['l_bband'] = data['m_bband'] - std_20d * 1.5

    #KELTNER CHANNELS
    atr_20d = ta.atr(data["High"], data["Low"], data["Close"], length=n)
    data['m_keltb'] = ta.ema(data['Close'], length = n)
    data['u_keltb'] = data['m_keltb'] + (1.5 * atr_20d)
    data['l_keltb'] = data['m_keltb'] - (1.5 * atr_20d)

    high_h = data['High'].rolling(n).max()
    low_l = data['Low'].rolling(n).min()
    hl_avg = (high_h + low_l) / 2
    hl_mean = (data['m_bband'] + hl_avg) / 2
    delta = data.Close - hl_mean
    data['delta'] = delta.rolling(n).mean()

    return data


def squeeze():
    data['sqz'] = 0
    #sqzOn = (lowerBB > lowerKC) & (upperBB < upperKC)
    data.loc[(data.l_bband > data.l_keltb) & (data.u_bband < data.u_keltb), 'sqz'] = 1
    #sqzOff = (lowerBB < lowerKC) & (upperBB > upperKC)
    data.loc[(data.l_bband < data.l_keltb) & (data.u_bband > data.u_keltb), 'sqz'] = -1
    #noSqz = (sqzOn == False) & (sqzOff == False)

    last_squeeze = 0
    for i in range(len(data)):
        # check for bullish signal
        if data.loc[i, 'sqz'] == 1:
            if last_squeeze == 0 or last_squeeze == -1:
                data.loc[i, 'sqz'] = 1
                last_squeeze = 1
            elif last_squeeze == 1 and i < len(data) - 1 and data.loc[i+1, 'sqz'] != data.loc[i, 'sqz']:
                data.loc[i, 'sqz'] = 0
            else:
                data.loc[i, 'sqz'] = 0
        # check for bearish signal
        elif data.loc[i, 'sqz'] == -1:
            if last_squeeze == 0 or last_squeeze == 1:
                data.loc[i, 'sqz'] = -1
                last_squeeze = -1
            elif last_squeeze == -1 and i < len(data) - 1 and data.loc[i+1, 'sqz'] != data.loc[i, 'sqz']:
                data.loc[i, 'sqz'] = 0
            else:
                data.loc[i, 'sqz'] = 0
        else:
            data.loc[i, 'sqz'] = 0

    data['sqz_label'] = np.where(data.sqz == 1, 'ON', np.where(data.sqz == -1, 'OFF', ''))

    return data


def TSI(n1, n2):
    ap = (data['High'] + data['Low'] + data['Close']) / 3
    esa = ap.ewm(span=n1, min_periods=n1).mean()
    d = abs(ap - esa).ewm(span=n1, min_periods=n1).mean()
    ci = (ap - esa) / (0.015 * d)
    tci = ci.ewm(span=n2, min_periods=n2).mean()
    data['TSI'] = tci
    
    return data


def signals(delta_h: int, delta_l: int):
    last_signal = 0
    for i in range(len(data)):
        # check for bullish signal
        if data.loc[i, 'delta'] >= delta_h:
            #if last_signal == 0 or last_signal == -1:
            data.loc[i, 'signal'] = 1
            #    last_signal = 1
            #elif last_signal == 1 and i < len(data) - 1 and data.loc[i+1, 'delta'] != data.loc[i, 'delta']:
            #    data.loc[i, 'signal'] = 0
            #else:
            #    data.loc[i, 'signal'] = 0
        # check for bearish signal
        elif data.loc[i, 'delta'] <= delta_l:
            #if last_signal == 0 or last_signal == 1:
            data.loc[i, 'signal'] = -1
            #    last_signal = -1
            #elif last_signal == -1 and i < len(data) - 1 and data.loc[i+1, 'delta'] != data.loc[i, 'delta']:
            #    data.loc[i, 'signal'] = 0
            #else:
            #    data.loc[i, 'signal'] = 0
        else:
            data.loc[i, 'signal'] = 0

    return data


def plot_SMI(data):
    fig = go.Figure()
    fig.add_trace(go.Scatter(x=data.index, y=data.u_bband,
                         mode='lines', line_color='red', name='Upper Bollinger Band'))
    fig.add_trace(go.Scatter(x=data.index, y=data.l_bband,
                         mode='lines', line_color='red', name='Lower Bollinger Band'))
    #fig.add_trace(go.Scatter(x=data.index, y=data.m_keltb,
    #                     mode='lines', line_color='green', name='Middle Kelter Channel'))
    fig.add_trace(go.Scatter(x=data.index, y=data.u_keltb,
                         mode='lines', line_color='green', name='Upper Kelter Channel'))
    fig.add_trace(go.Scatter(x=data.index, y=data.l_keltb,
                         mode='lines', line_color='green', name='Lower Kelter Channel'))
    fig.update_layout(title='SMI Chart',
                      xaxis_title='Date',
                      yaxis_title='SMI')
    
    return fig.show()

    #fig, ax = plt.subplots(figsize=(20,5))
    #ax.plot(data.loc[data['signal'] == 1].index, data['Close'][data['signal'] == 1], '^', markersize=10, color='g', label='Buy Signal')
    #ax.plot(data.loc[data['signal'] == -1].index, data['Close'][data['signal'] == -1], 'v', markersize=10, color='r', label='Sell Signal')
    #plt.show()


def plot_Signals(data):
    linechart = go.Scatter(x=data.index,
                           y=data['Close'],
                           mode='lines',
                           name='Closing Prices')
    
    buy_signals = data[data['signal'] == 1]
    sell_signals = data[data['signal'] == -1]
    buy_trace = go.Scatter(x=buy_signals.index,
                        y=buy_signals['Close'],
                        mode='markers',
                        marker=dict(symbol='triangle-up', size=10, color='green'),
                        name='Buy Signal')
    sell_trace = go.Scatter(x=sell_signals.index,
                            y=sell_signals['Close'],
                            mode='markers',
                            marker=dict(symbol='triangle-down', size=10, color='red'),
                            name='Sell Signal')
    #annot_trace = go.Scatter(x=data.index, y=data.Close, mode='text', name='Squeeze Status',
    #                      text=data.sqz_label, textposition='bottom center', showlegend=False)
    
    data = [linechart, buy_trace, sell_trace]#, annot_trace]
    fig = go.Figure(data=data)
    #fig.show()

    return fig

def plot_TSI(data):
    data['above_zero'] = data['TSI'] > 0

    # Create traces for above and below zero
    trace_above = go.Scatter(x=data.index,
                              y=data['TSI'],
                              mode='lines',
                              name='TSI line above 0',
                              fill='tozeroy',  # fill above the line
                              fillcolor='green',
                              line=dict(color='green'),
                              opacity=0.5,  # set the opacity to 0.5 to see the line
                              visible='legendonly',  # only show in legend
                              showlegend=True  # show in legend
                             )
    trace_below = go.Scatter(x=data.index,
                              y=data['TSI'],
                              mode='lines',
                              name='TSI line below 0',
                              fill='tozeroy',  # fill below the line
                              fillcolor='red',
                              line=dict(color='red'),
                              opacity=0.5,  # set the opacity to 0.5 to see the line
                              visible='legendonly',  # only show in legend
                              showlegend=True  # show in legend
                             )

    fig = go.Figure()
    fig.add_trace(trace_above)
    fig.add_trace(trace_below)

    # Update the layout
    fig.update_layout(
        title='TSI line',
        xaxis_title='Date',
        yaxis_title='TSI',
        legend=dict(
            title='TSI lines',
            orientation='h',
            yanchor='bottom',
            y=1.02,
            xanchor='right',
            x=1
        ),
    )

    return fig

def refresh_page():
    st.experimental_rerun()

if __name__ == '__main__':
    st.header("Calculate the Simple Moving Averages (Moving Average Crossovers)")
    #st.subheader("movingAvgs( 1st Moving Average Period, 2nd Moving Average Period)")
    #movAvg1 = st.text_input('Enter SMA 1 period: ', 21)
    #movAvg2 = st.text_input('Enter SMA 2 period: ', 7)
    #movAvg1 = int(movAvg1)
    #movAvg2 = int(movAvg2)
    #movingAvgs(movAvg1,movAvg2)
    movingAvgs(21, 7)

    iMACD()

    #ene_iMACD(0.035)

    #st.header("Calculate the Squeeze Momentum Indicator values")
    #smi_timef = st.text_input('Enter SMI lookback period ', 7)
    #smi_timef = int(smi_timef)
    #ene_SMI(smi_timef)
    ene_SMI(7)

    squeeze()

    st.header("Calculate the BUY/SELL Signals")
    signals_b = st.text_input('Enter BUY threshold (positive)', 30)
    signals_s = st.text_input('Enter SELL threshold (negative)', -32)
    signals_b = int(signals_b)
    signals_s = int(signals_s)
    signals(signals_b, signals_s)
    #st.dataframe(signals(signals_b, signals_s))

    #plot_SMI(data)

    TSI(10,21)

    if st.button('Refresh'):
        refresh_page()

    st.header("Visualize the BUY/SELL Signals")
    #st.plotly_chart(plot_Signals(data))
    fig = plot_Signals(data)
    st.plotly_chart(fig)

    #fig2 = plot_TSI(data)
    #st.plotly_chart(fig2)
