import os
import requests
from datetime import datetime, timedelta
from pytube import YouTube
from moviepy.editor import VideoFileClip
from tqdm import tqdm
from others import *

def download_youtube(url, nama_channel, new_name):
    response = requests.get(url, stream=True)
    file_name = new_name + ".mp4"

    download = f"/home/user/app/Hasil Download/Youtube/{nama_channel}"
    if not os.path.exists(download):
        os.makedirs(download)

    filename = f"{download}/{file_name}"
    with open(filename, 'wb') as file:
        total_size = int(response.headers.get("Content-Length", 0))
        progress_bar = tqdm(total=total_size, unit="B", unit_scale=True, ncols=80)

        for chunk in response.iter_content(chunk_size=1024):
            if chunk:
                file.write(chunk)
                progress_bar.update(len(chunk))

        progress_bar.close()
        print("")

    return filename
    
def youtube(link, resolusi_input):
    video_info = ""
    yt = YouTube(link)
    nama_channel = yt.author
    judul_video = yt.title.replace('/', '-').replace('\\', '-')
    tanggal_upload = yt.publish_date.strftime("%-d %B %Y")
    jumlah_viewer = format_number(yt.views)
    selisih_hari = (datetime.now() - yt.publish_date).days
    rata2_viewer_per_hari = format_number(int(yt.views if selisih_hari < 1 else yt.views / selisih_hari))
    durasi_video = str(timedelta(seconds=yt.length))

    video_info = f"Nama Channel: {nama_channel}\n"
    video_info += f"Judul Video: {judul_video}\n"
    video_info += f"Tanggal Upload: {tanggal_upload}\n"
    video_info += f"Jumlah Viewer: {jumlah_viewer}\n"
    video_info += f"Rata-rata Viewer per Hari: {rata2_viewer_per_hari}\n"
    video_info += f"Durasi Video: {durasi_video}\n"
    thumbnail_dir = f"/home/user/app/Hasil Download/Youtube/{nama_channel}"
    if not os.path.exists(thumbnail_dir):
        os.makedirs(thumbnail_dir)

    # Mendapatkan URL thumbnail
    thumbnail_url = yt.thumbnail_url

    # Menentukan nama file thumbnail
    thumbnail_file = download_file(thumbnail_url, judul_video, thumbnail_dir)

    resolusi_tersedia = [stream.resolution for stream in yt.streams.filter(progressive=True)]
    video_info += f"Resolusi yang tersedia: {', '.join(resolusi_tersedia)}\n"

    resolusi = str(resolusi_input) + "p"
    stream = yt.streams.filter(progressive=True, resolution=resolusi).first()

    if stream is None:
        stream = yt.streams.filter(progressive=True, resolution='360p').first()
        video_file = download_youtube(stream.url, nama_channel, judul_video)
        return video_file, judul_video, video_info, thumbnail_file
    else:
        video_file = download_youtube(stream.url, nama_channel, judul_video)
        return video_file, judul_video, video_info, thumbnail_file