from bs4 import BeautifulSoup
from others import *

def get_info_sankaku(soup: BeautifulSoup):
    # Find the artist information
    artist_tag = soup.find('li', class_='tag-type-artist')
    artist = artist_tag.find('a')['href'].split('=')[-1]
    artist = artist.replace('_', ' ').title()

    # Find the series information
    series_tag = soup.find('li', class_='tag-type-copyright')
    series = series_tag.find('a')['href'].split('=')[-1]
    series = series.replace('_', ' ').title()

    # Find the characters information
    characters_tags = soup.find_all('li', class_='tag-type-character')
    characters = []
    for tag in characters_tags:
        character = tag.find('a')['href'].split('=')[-1]
        character = character.replace('_', ' ').title()
        characters.append(character)
    characters = ', '.join(characters)

    # Find the link information
    link_tag = soup.find('source')
    link = 'https:' + link_tag['src']

    return artist, series, characters, link