from bs4 import BeautifulSoup
import re
from others import *

def get_info_bunkrr(soup: BeautifulSoup):
    # Mencari judul video di elemen <title>
    title = soup.find("title")
    if title:
        video_title = title.text

        # Ubah '&amp;' menjadi '&'
        video_title = video_title.replace('&amp;', '&')

        # Jika ada karakter '-' maka cari '-' paling belakang dan hapus mulai dari itu sampai ke belakang
        if '-' in video_title:
            last_dash_index = video_title.rfind('-')
            video_title = video_title[:last_dash_index]

        # Sisa dari karakter '-' ubah menjadi ' '
        video_title = video_title.replace('-', ' ')

        # Mencari link download yang berawalan https dan berakhiran .mp4
        link_download = soup.find("source", src=re.compile(r'^https.*\.mp4$'))
        if link_download:
            link_download = link_download['src']

            # Ubah '&amp;' menjadi '&'
            link_download = link_download.replace('&amp;', '&')
            print(link_download)
        else:
            link_download = ''

        return video_title, link_download
    else:
        print("Tidak ditemukan elemen <title>")
        return '', ''