import pickle
import gradio as gr

from sklearn.feature_extraction.text import TfidfVectorizer


filename = 'movie_reviews_sentiment_analysis.pkl'
vector = 'vectorizer.pkl'

#Load and test saved model
loaded_model = pickle.load(open(filename, 'rb'))
loaded_vector = pickle.load(open(vector, 'rb'))

def movie_review(review):

    new_review = loaded_vector.transform([review])
    
    result = loaded_model.predict(new_review)
    
    return result

#create input and output objects
#input object1
input = gr.inputs.Textbox(label="Enter Review")

#output object
output = gr.outputs.Textbox(label= "Review Prediction") 

#create interface
gui = gr.Interface(fn=movie_review,
                   inputs=[input],
                   outputs=output).launch()