import streamlit as st  #Web App
import os
import stqdm
import time
from utils import *

api_key = ' '

st.write(
    """<style>
    [data-testid="column"] {
        width: calc(50% - 1rem);
        flex: 1 1 calc(50% - 1rem);
        min-width: calc(50% - 1rem);
    }
    </style>""",
    unsafe_allow_html=True,
)


st.title("PDB Scientist 🧑‍🔬")
st.markdown("Geemi Wellawatte ([@GWellawatte](https://twitter.com/GWellawatte))")
st.markdown("#### This tool will allow you information related to a protein. You only have to enter the PDB ID of the related protein. It uses OpenAI's GPT models, and you must have your own API key. Each query is about 10k tokens, which costs about only $0.20 on your own API key, charged by OpenAI.")
st.markdown("##### Current version queries articles listed in the PDB database with relevance to the PDB ID, from the PubMed database. ")
st.markdown("##### Currently data is extracted from the abstracts only as this is a ✨FREE✨ paper-scraper!")
st.markdown("Used libraries:\n * [PaperQA](https://github.com/whitead/paper-qa)")

api_key_url = 'https://help.openai.com/en/articles/4936850-where-do-i-find-my-secret-api-key'

api_key = st.text_input('OpenAI API Key',
         placeholder='sk-...', 
         help=f"['What is that?']({api_key_url})",
         type="password",
         value = '')     

os.environ["OPENAI_API_KEY"] = f"{api_key}" 
if len(api_key) != 51:
    st.warning('Please enter a valid OpenAI API key.', icon="⚠️")


with st.form(key='pdbid_form', clear_on_submit = False):
    pdbid = st.text_input("Input search query here:", placeholder='PDB ID', value= '')

    submitButton1 = st.form_submit_button('Submit')

if submitButton1:
    st.write("PDB ID submitted! ✅")
    pdb_query = PDBQuery(pdbid)
    citations = pdb_query.create_citation()
    if 'citations' not in st.session_state: 
        st.session_state.key = 'citations'
    st.session_state['citations'] = citations

    pdb_query.write_webdata()

def answer_query(question):
    import paperqa

    citations = st.session_state['citations']

    docs = paperqa.Docs()
    docs.add('web_data.txt', ''.join(citations))

    answer = docs.query(question)

    st.success('Found answer 🥳')
    return answer.formatted_answer

with st.form(key='question_form', clear_on_submit = False):
    question = st.text_input("What do you wanna know from these papers?", placeholder='Input questions here...',
                    value='')

    submitButton2 = st.form_submit_button('Submit')

if submitButton2:
    with st.spinner('⏳ Please wait...'):
        start = time.time()
        paperqa_answer = answer_query(question)
        length_answer = len(paperqa_answer)
        st.text_area("Answer:", paperqa_answer, height=max(length_answer//4, 100))
        end = time.time()
        clock_time = end - start
        with st.empty():
            st.write(f"⏰ Task completed in {clock_time:.2f} seconds.")
    
    
    
clearButton = st.button('Clear data!')
if clearButton:
    st.write('Extracted data is removed 😶‍🌫️')
    if os.path.exists('web_data.txt'): 
        os.remove('web_data.txt')